/****************************************************************************/
/*  nRF24L1 module library                                                  */
/****************************************************************************/
/*  LEnsE / Julien VILLEMEJANE       /   Institut d'Optique Graduate School */
/****************************************************************************/
/*  Library - nRF24.cpp file                                                */
/****************************************************************************/
/*  Tested on Nucleo-L476RG / 4th nov 2021                                  */
/****************************************************************************/

#include "nRF24.h"

#define TRANSFER_SIZE   8

nRF24L01P       nRF24_mod(D11, D12, D13, D10, D9, PB_8);
// MOSI, MISO, SCK, CSN, CE, IRQ

char k;
char    dataToSend[TRANSFER_SIZE] = {0xAA, 0x01, 0x10, 0xF0,0xAA, 0x01, 0x10, 0xF0};
char    dataReceived[TRANSFER_SIZE] = {0};
char    rxDataCnt;


// Fonction d'initialisation du module BT nRF24L01
void initNRF24(){
    nRF24_mod.powerUp();
    wait_us(100000);
    nRF24_mod.setAirDataRate(NRF24L01P_DATARATE_250_KBPS);
    nRF24_mod.setRfFrequency(2400);
    wait_us(100000);
    debug_pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  nRF24_mod.getRfFrequency() );
    debug_pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  nRF24_mod.getRfOutputPower() );
    debug_pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", nRF24_mod.getAirDataRate() );
    debug_pc.printf( "Transfers are grouped into %d characters\r\n", TRANSFER_SIZE );
    nRF24_mod.setTransferSize( TRANSFER_SIZE );
    nRF24_mod.setReceiveMode();
    nRF24_mod.enable();
}

// Fonction de test du module BT nRF24L01
void testNRF24(void){
    /* Lecture donnée depuis nRF24 */
    if ( nRF24_mod.readable() ) {

        // ...read the data into the receive buffer
        rxDataCnt = nRF24_mod.read( NRF24L01P_PIPE_P0, dataReceived, TRANSFER_SIZE);

        // Display the receive buffer contents via the host serial link
        debug_pc.printf("\tD = ");
        for ( int i = 0; i < rxDataCnt; i++ ) {
            debug_pc.printf(" %x \t", dataReceived[i]);
        }
        debug_pc.printf("\r\n");
    }   
    /* Transmission donnée depuis nRF24 */
    if(bp_int == 0){
        nRF24_mod.setRfFrequency(2400);
        nRF24_mod.write( NRF24L01P_PIPE_P0, dataToSend, TRANSFER_SIZE );
        debug_pc.printf( "SENDED\r\n");
        wait_us(100000);
    }
}