#include "mbed.h"
#include "PixelArray.h"
#include "WS2812.h"

#define WS2812_BUF  64

#define BLACK       0x00000000
#define WHITE       0x00FFFFFF
#define WHITEW      0xFFFFFFFF
#define GRAY        0x00808080
#define RED         0x00FF0000
#define ORANGE      0x00FFA500
#define BLUE        0x000000FF
#define DARKGREEN   0x00006400
#define DARKCYAN    0x00008B8B
#define INDIGO      0x004B0082

/* Variables globales */
Serial my_pc(USBTX, USBRX);
PixelArray px(WS2812_BUF);
int i;

// For Nucleo F476 : 3, 12, 9, 12
WS2812 ws(D7, WS2812_BUF, 3, 12, 9, 12);

void afficheArray(PixelArray pxi, int size){
    int k;
    int *pixels = px.getBuf();
    for(k = 0; k < size; k++){
        my_pc.printf("i %d / pix %d \r\n", k, *(pixels+k));
    }
}

void blackGrille(void){
    for (i = 0; i < WS2812_BUF; i++) {
        px.Set(i, BLACK);
    }     
    ws.write(px.getBuf());
}

void whiteGrille(void){
    for (i = 0; i < WS2812_BUF; i++) {
        px.Set(i, WHITEW);
    }     
    ws.write(px.getBuf());
}

int main() {
    ws.useII(WS2812::GLOBAL);
    ws.setII(100); 
    /*
    while(1){
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, 255);
        }     
        ws.write(px.getBuf());
        wait(0.2);
    }
    
    */
    
    blackGrille();
    wait(1);
    /*
    whiteGrille();
    wait(0.5);
    blackGrille();
    wait(0.5);
    */
    while(1){
        /* Reinitialisation ecran */
        
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, BLACK);
        }     
        ws.write(px.getBuf());
        wait(0.2);
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, BLUE);
        }     
        ws.write(px.getBuf());
        wait(0.2);
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, WHITE);
        }     
        ws.write(px.getBuf());
        wait(0.2);
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, RED);
        }     
        ws.write(px.getBuf());
        wait(0.2);
        for (i = 0; i < WS2812_BUF; i++) {
            px.Set(i, BLACK);
        }     
        ws.write(px.getBuf());
        wait(1);   
        
    }
}
