#include "mbed.h"

/* USART通信ピン設定 */
Serial pic(D8, D2); //TX, RX

/* i2c通信ピン設定 */
I2C i2c(D14, D15);  //SDA, SCL

/* 確認LED設定 */
DigitalOut myled(D13);

/* 緊急停止ピン設定 */
DigitalOut emergency(D9);

/* 各関数の宣言 */
void ice(int address, int data);
void dev_rx();
void photo();


/* 右前メカナム */
int send_data1 = 0x30;

/* 右後メカナム */
int send_data2 = 0x30;

/* 左前メカナム */
int send_data3 = 0x30;

/* 左後メカナム */
int send_data4 = 0x30;

/* 射撃機構 */
int send_data5 = 0x30;

int send_data6 = 0x30;

/* 緊急停止用フラグ */
int emergency_flag = 0;

void ice(int address, int data) //I2C関数
{
    /* 周波数: 100kHz */
    //i2c.frequency(100000);
    
    /* スタートコンディション出力 */
    i2c.start();
    
    /* アドレスの書き込み */   
    i2c.write(address);
    
    /* データの書き込み */
    i2c.write(data);
    
    /* ストップコンディション出力 */
    i2c.stop();
}

void dev_rx()
{
    /* ボーレートの設定 */
    pic.baud(115200);
    
    /* 各ボタンが押された時の処理 */
    int rcv_data = pic.getc();
    
    
    
    if(rcv_data ==0x17){
        send_data5 = 0x02;
        myled = 1;
    }else if(rcv_data == 0x18){
        send_data6 = 0x02;
        myled = 1;
    }

    /* -------------移動機構--------------- */
    //前進
    if(rcv_data == 0x01){   //前進50%   
        send_data1 = 0x02;
        send_data2 = 0x02;
        send_data3 = 0x02;
        send_data4 = 0x02;
        
        myled = 1;
        
    }else if(rcv_data == 0x05){ //前進 90%
        send_data1 = 0x03;
        send_data2 = 0x03;
        send_data3 = 0x03;
        send_data4 = 0x03;
        
        myled = 1;
        
    }else if(rcv_data == 0x09){ //前進 10%
        send_data1 = 0x01;
        send_data2 = 0x01;
        send_data3 = 0x01;
        send_data4 = 0x01;
        
        myled = 1;
    }else if(rcv_data == 0x02){ //後進 50%
        send_data1 = 0x05;
        send_data2 = 0x05;
        send_data3 = 0x05;
        send_data4 = 0x05;
        
        myled = 1;
    }else if(rcv_data == 0x06){ //後進 90%
        send_data1 = 0x06;
        send_data2 = 0x06;
        send_data3 = 0x06;
        send_data4 = 0x06;
        
        myled = 1;
    
    }else if(rcv_data == 0x10){ //後進 10%
        send_data1 = 0x04;
        send_data2 = 0x04;
        send_data3 = 0x04;
        send_data4 = 0x04;
        
        myled = 1;
        
    }else if(rcv_data == 0x03){ //右平衡移動 50%
        send_data1 = 0x05;
        send_data2 = 0x02;
        send_data3 = 0x05;
        send_data4 = 0x02;
        
        myled = 1;
    }else if(rcv_data == 0x07){ //右平行移動 90%
        send_data1 = 0x06;
        send_data2 = 0x03;
        send_data3 = 0x06;
        send_data4 = 0x03;
        
        myled = 1;
    }else if(rcv_data == 0x11){ //右平衡移動 10%
        send_data1 = 0x04;
        send_data2 = 0x01;
        send_data3 = 0x04;
        send_data4 = 0x01;
        
        myled = 1;
    }else if(rcv_data == 0x04){ //左平衡移動 50%
        send_data1 = 0x02;
        send_data2 = 0x05;
        send_data3 = 0x02;
        send_data4 = 0x05;
        
        myled = 1;
    }else if(rcv_data == 0x08){ //左平衡移動 90%
        send_data1 = 0x03;
        send_data2 = 0x06;
        send_data3 = 0x03;
        send_data4 = 0x06;
        
        myled  = 1;
    }else if(rcv_data == 0x12){ //左平衡移動 10%
        send_data1 = 0x01;
        send_data2 = 0x04;
        send_data3 = 0x01;
        send_data4 = 0x04;
        
        myled = 1;
    
    }else if(rcv_data == 0x13){ //右旋回
        send_data1 = 0x05;
        send_data2 = 0x02;
        send_data3 = 0x02;
        send_data4 = 0x05;
        
        myled = 1;
    }else if(rcv_data == 0x15){
        send_data1 = 0x04;
        send_data2 = 0x01;
        send_data3 = 0x01;
        send_data4 = 0x04;
        
        myled = 1;
    
    }else if(rcv_data == 0x14){ //左旋回
        send_data1 = 0x02;
        send_data2 = 0x05;
        send_data3 = 0x05;
        send_data4 = 0x02;
        
        myled = 1;
    }else if(rcv_data == 0x16){
        send_data1 = 0x01;
        send_data2 = 0x04;
        send_data3 = 0x04;
        send_data4 = 0x01;
        
        myled = 1;
    }
    
    
    /* 緊急停止始動 */
    else if(rcv_data == 0x2B){
        emergency_flag = 1;
        myled = 1;
    }
    
    /* 緊急停止解除 */
    else if(rcv_data == 0x2C){
        emergency_flag = 0;
        myled = 1;
    }
        
    else if(rcv_data == 0x30){
        send_data1 = 0x30;
        send_data2 = 0x30;
        send_data3 = 0x30;
        send_data4 = 0x30;
        send_data5 = 0x30;
        send_data6 = 0x30;
        
        myled = 0; 
        
    }
    
    /* 緊急停止関数 */
    if(emergency_flag == 1){
        emergency = 1;
        myled = 1;
        
    } else {
        emergency = 0;
        myled = 0;
    }
}

/* メイン関数 */
int main(void)
{
    /* 緊急停止解除 */
    emergency = 0;
    
    /* 無限ループ関数 */
    while(1)
    {   
        
        dev_rx();
        /* 割り込み受信関数の呼び出し */
        pic.attach(dev_rx, Serial::RxIrq);
        
        
        /* i2c関数の呼び出し */
        ice(0xA0, send_data1);
        ice(0xA2, send_data2);
        ice(0xA4, send_data3);
        ice(0xA6, send_data4);
        ice(0xA8, send_data5);
        ice(0xAA, send_data6);
    }
}