//------------------------------------------------------------
// Demo program for LCD ACM1602NI using I2C interface.
//      Pullup resistors for SDA and SCL: 4.7 kΩ.
//  Product name of LCD: ACM1602NI-FLW-FBW-M01
//  See http://akizukidenshi.com/catalog/g/gP-05693/
//
//  2014/12/14, Copyright (c) 2014 MIKAMI, Naoki
//------------------------------------------------------------

//#include "mbed.h"
#include "ACM1602NI.hpp"
using namespace Mikami;

Acm1602Ni lcd_;                               // Default, OK
//Acm1602Ni lcd_(D14, D15);                     // OK
//Acm1602Ni lcd_(D14, D15, 200000);             // OK
//Acm1602Ni lcd_(D14, D15, 200000, true, true); // OK
//Acm1602Ni lcd_(PB_3, PB_10);                  // OK
//Acm1602Ni lcd_(PC_9, PA_8);                   // OK
//Acm1602Ni lcd_(PB_4, PA_8);                   // OK

Ticker timer_;

// Display 0, 1, 2, .....
void TimerIsr()
{
    static int k = 0;
    int sec = k % 60;   // seconds
    int min = k / 60;   // minits
    char str[20];
    sprintf(str, "%d'%2d\"", min, sec);
    lcd_.WriteStringXY(str, 0, 1);
    k++;
}

int main()
{
    lcd_.Clear();
    lcd_.WriteString("Hello World!");

    TimerIsr();
    timer_.attach(&TimerIsr, 1);

    while (true) {}
}
