/* voiceecho.cpp */
// voice input to ADC is delayed for 0.1 to 0.5 sec and output to DAC and PWM
// Copyright Toshihiro Matsui, IISEC, April 2019
// Any use/copy/modify of this program is fully granted to anyone by the author.
//


#include "mbed.h"

DigitalOut led1(LED1);
PwmOut pwm(p21);
AnalogIn mic(p20);
AnalogOut spk(p18);
Ticker voicetick;

#define WAVMAX 10000  /*buffer size; SAMPFREQ*DEALY<WAVMAX*/
#define SAMPFREQ 16000.0
#define DELAY 0.3 /*s*/

unsigned short wave[WAVMAX];
int readindex=0, writeindex=0, wavmax=WAVMAX;

class KBline : public Serial
{
public:
    char line[100];
    int  index;
    int  receiving; //status 0=not started, 1=waiting, 2=receiving, 3=end
private:
    void serialirq()
    {
        char ch;
        if (this->readable()) {
            ch=this->getc();
            switch(ch) { //simple line editing
                case '\n':
                case '\r':  //LF and CR terminate reading
                    line[index++]=ch;
                    line[index++]=0;
                    this->printf("\r\n");
                    receiving=3;
                    break;
                case 21:  /* control-U cancels entire line*/
                    this->printf("\n\r");
                    index=0;
                    break;
                case 0x08:
                case 0x7f: /*BS and DEL delete the last character*/
                    if (index>0) {
                        index--;
                        this->putc(0x08);
                        this->putc(0x20);
                        this->putc(0x08);
                    }
                    break;
                default:
                    receiving=2;
                    line[index++]=ch;
                    this->putc(ch);
                    break;
            }        }    }
public:
    KBline(PinName tx, PinName rx) : Serial(tx, rx)
    {
        receiving=0;
    }
    //  KBline(Serial *pc) { term=pc; }; //constructor
    void start_getline()
    {
        index=0;
        receiving=1;
        this->attach(this, &KBline::serialirq);
    }
    // int receiving() { return(receiving);}
    char *getline()
    {
        while (receiving!=3) wait(0.1);
        receiving=0;
        return(line);
    }
} ;

int newindex(int ix)
{   if (ix<0) ix += wavmax;
    return(ix % wavmax); }

void voice_io()    /*timer driven*/
{   unsigned short val;
    wave[readindex]= wave[readindex]*0.45+mic.read_u16()*0.55;  //mic.read()*30000;
    val=wave[writeindex];
    pwm.write((float)val/65536.0);
    spk.write_u16(val); // (val/30000.0  );
    readindex=newindex(readindex+1);
    writeindex=newindex(writeindex+1);
}

int main()
{
    KBline pc(USBTX, USBRX);
    float delay=DELAY;

    pc.baud(9600);
    pwm.period_us(32);  /* 62.5us*/
    delay=DELAY;
    readindex=0;
    wavmax=delay*SAMPFREQ+1;
    writeindex=newindex(readindex-delay*SAMPFREQ);
    voicetick.attach(voice_io, 1.0/SAMPFREQ);
    pc.printf("echo machine  delay=%fs\n\r", delay);
    while (true) {
        pc.start_getline();
        while (pc.receiving!=3) {
            led1 = !led1;
            wait(0.2);
        }
        sscanf(pc.line,"%f", &delay);  /* multiple of 0.1s */
        readindex=0;
        wavmax=delay*SAMPFREQ+1;
        writeindex=newindex(readindex-delay*SAMPFREQ);
        pc.printf("new delay %5.2fs  r=%d  w=%d  val=%d\n\r", delay, readindex, writeindex, wave[writeindex]);
    }
}

