/*

PONY_sense.cpp
(C) 2015 Igor Institute

*/

#include "PONY_sense.h"

#define THROWAWAY

#ifdef THROWAWAY
// Codes for a throwaway M2X device
#define M2XAPIKEY "54c6bbf11012f34830bd23cc091ca250"
#define DEVID "b9c57667ee0495dc0b3cddd890f8d2df"
#endif

#ifndef THROWAWAY
// v1.2 codes
#define M2XAPIKEY "bbc483492238dc76f7d12f0cd6e13a4b"
#define DEVID "3764db38b6c9ec4045a38e0125b14b4c"
#endif












// Convert voltage across thermistor to temperature
// Right now, this math assumes we're using a Vishay NTCLG100E2 thermistor

// Thermistor values vs. temperature (-20C to 100C x 5C)
// NOTE: This setup assumes that we're measuring a thermistor where one end is connected directly to ground
float thermistorToTemp(float thermVoltage) {
    float nomCurrent = 0.0000825;   // This is the set current of the current configuration (on breadboard, 2015-12-17)
    float nomResistance = thermVoltage / nomCurrent;
    
    //printf("nomResistance = %.2f\r\n", nomResistance);
    
    //float nomTemp = -25.87 * log(nomResistance) + 266.53; // Best fit for Vishay NTCLG100E2 between -20C and 100C; R = 0.99228
    float nomTemp = -26.68 * log(nomResistance) + 272.96; // Best fit for Cantherm CWF3AA103G3380 between -20C and 100C; R = 0.99041
    
    return nomTemp;
    
};

float getTemp(AnalogIn* pTempPin) {
    float tempV = *pTempPin;
    float temp = thermistorToTemp(AINTOV(tempV));
    
    return temp;
}

// Records and sends the temperature up to the M2X cloud
int logTemp(AnalogIn* pTempPin, float* pTemp, M2XStreamClient* m2x) {
    *pTemp = getTemp(pTempPin);
    printf("Temp=%f\r\n", *pTemp);
    
    int ret = m2x->updateStreamValue(DEVID, "kegtemp", *pTemp);
    printf("m2x ret=%i\r\n",ret);
    
    return ret;
    
}





//-----------------------------------------------
//-----------------------------------------------

#define AX_WRITE_REG    0x3A
#define AX_READ_REG     0x3B

#define AX_WHOAMI_REG   0x0F

#define AX_CONFIG1_REG  0x20 
#define AX_CONFIG1_VAL  0xC7


#define AX_X_REG        0x29
#define AX_Y_REG        0x2B
#define AX_Z_REG        0x2D

#define AX_NEWFILTER    0b00000111





void LIS331write(I2C* axis, int targetReg, int targetVal) {
    axis->start();
    
    axis->write(AX_WRITE_REG);
    axis->write(targetReg);
    axis->write(targetVal);
    
    axis->stop();

    return;    
}

int LIS331read(I2C* axis, const int readReg, int* readVal) {
    axis->start();
    
    axis->write(AX_WRITE_REG);
    axis->write(readReg);
    
    axis->start();
    axis->write(AX_READ_REG);
    *readVal = axis->read(1);
    
    axis->stop();
    return *readVal;    
}

int LIS331read(I2C* axis, const int readReg) {
    axis->start();
    
    axis->write(AX_WRITE_REG);
    axis->write(readReg);
    
    axis->start();
    axis->write(AX_READ_REG);
    int readVal = axis->read(1);
    
    axis->stop();
    return readVal;    
}


int configureAccel(I2C* axis) {
    axis->frequency(400); 

    LIS331write(axis, AX_CONFIG1_REG, AX_CONFIG1_VAL);
    int configVal = 0;
    LIS331read(axis, AX_CONFIG1_REG, &configVal);

    return configVal;
}

// Query the WHOAMI register; should return 0x3B
int accelWhoAmI (I2C* axis) {
    int axID = 0;
    
    LIS331read(axis, AX_WHOAMI_REG, &axID);
    
    return axID;   
}

int accelX (I2C* axis) {
    int xAccel = 0;
    
    LIS331read(axis,AX_X_REG,&xAccel);

    return xAccel;
}

int accelY (I2C* axis) {
    int yAccel = 0;
    
    LIS331read(axis,AX_Y_REG,&yAccel);

    return yAccel;
}


int accelZ (I2C* axis) {
    int zAccel = 0;
    
    LIS331read(axis,AX_Z_REG,&zAccel);

    return zAccel;
}




// FSR interpretation


#define FSR_THRESHOLD 0.860

// TODO: Calibrations for different keg sizes

float getWeight(AnalogIn* pFSRvolt) {
    
    float fsrVa = *pFSRvolt;
    float fsrV = AINTOV(fsrVa);
    
    //printf("fsrV = %.3f \r\n",fsrV);
    
    if(fsrV <= FSR_THRESHOLD)
        return 0;
    
    
    float kegW = 23839 * (fsrV * fsrV) - 41348 * fsrV + 17936;      // Based on fit to empty weights and 50L when full

    return kegW; 
    
}








// Returns 0-255 for proportional fill level
int fillLevel(float kegW, float emptyW) {
    
    
    
    

}








// Torn-out accelerometer code
/*

    // ACCELEROMETER    
    
    //printf("Set up accelerometer\r\n");

    printf("I2C write address ID: %01x\r\n",(LIS331_I2C_ADDRESS << 1) & 0xFE );
    printf("I2C read address ID: %01x\r\n",(LIS331_I2C_ADDRESS << 1) | 0x01 );
    
    printf("axleID=%01x\r\n", axle.getWhoAmI());
    
    // Set and read power mode
    axle.setPowerMode(NORMAL_400HZ);
    printf("axle Power Mode = %01x\r\n",axle.getPowerMode());
    
    printf("axle AccelStatus = %01x\r\n", axle.getAccelStatus());
    
    //float axleAccelZ = ();
    
    

    printf("Begin accel loop\r\n\n");
    while(true){
        printf("Z accel = %02f\r\n", axle.getAccelZ());
        printf("X accel = %02f\r\n", axle.getAccelX());
        printf("Y accel = %02f\r\n", axle.getAccelY());

        
        delay(5000);        
    };


*/
