#include "mbed.h"

//------------------------------------------------------------------------------------
// C027 Support Libraries
#include "GPS.h"
#include "MDM.h"

#include "C027.h"

// Power control libraries
#include "PowerControl.h"
#include "EthernetPowerControl.h"

// MOD I2C
//#include "MODI2C.h"

// M2X Support Libraries
#include <jsonlite.h>
#include "M2XStreamClient.h"

// PONY-specific config support libraries
#include "LIS331.h"
#include "PONY_Loc.h"       // PONY Location Code
#include "PONY_sense.h"

//----
// DEBUG DEFINITIONS
//#define THROWAWAY
//#define MDMDEBUG
#define LOCDEBUG

//------------------------------------------------------------------------------------
// Cellular modem/SIM parameters
#define SIMPIN      "1111"          //!SIMPIN is 1111 by default for AT&T SIMs.
#define APN         "m2m.com.attz"  // Defined AT&T M2M APN
#define USERNAME    NULL            //! Set the user name for your APN, or NULL if not needed (which, apparently, it isn't)
#define PASSWORD    NULL            //! Set the password for your APN, or NULL if not needed (which, apparently, it isn't)

//------------------------------------------------------------------------------------
// AT&T M2X Kekys


#ifdef THROWAWAY
// Codes for a throwaway M2X device
#define M2XAPIKEY "97f6f92f72b9dd1c66e9b81b982bc3ec"
#define DEVID "743fe2502be9d4d0c550ffa9340998a3"
#endif

#ifndef THROWAWAY
// v1.4 codes
#define M2XAPIKEY "537d09e921aa6589523e10aecde17a44"
#define DEVID "59a85c486aaf8dd427945320f4f779eb"
#endif


//------------------------------------------------------------------------------------
// PIN Config
DigitalOut led1(LED1);
DigitalOut led2(LED2);

AnalogIn   tempPin(P0_23);      // Label A0 -- Temperature
AnalogIn   fsrPin(P0_24);      // Label A1 -- FSR output voltage
//AnalogIn   tempGnd(P0_24);

// Accelerometer
//I2C axis(P0_0, P0_1);       // SDA, SCL
//MODI2C axisMod(P0_0, P0_1);   // Using MODI2C library

//LIS331 axle(P0_0, P0_1);        // Library object


/* POWER CONFIG
5V:     To thermistor system, to FSR opamp
3.3V:   To FSR input voltage, to LIS331 accelerometer

*/

//------------------------------------------------------------------------------------
// GLOBAL VARIABLES

Ticker flipper;

// M2X Drivers
Client client;
M2XStreamClient m2xClient(&client, M2XAPIKEY);
int M2X_response;   // For m2x message responses


char statusBuf[145] = "";

// Location reading
unsigned int kLocLoopDelayDef = 30 * 1000;         // The default loop waiting time for location reads
unsigned int kLocLoopDelay = kLocLoopDelayDef;


unsigned int kReadingDelay = 3 * 60 * 1000;         // How many seconds to wait between reads
unsigned int kReadingDelayClimb = 15000;    // How many seconds to add to the wait period when sitting idle
unsigned int kReadingDelayMax = 5 * 60000;  // What's the maximum time between readings?


// System time
time_t kSysSeconds = time(NULL);
time_t thisTime = time(NULL);
bool kSysClockSet = false;
tm kFormatTime;



// Global function definitions

void flip() {
    led1 = !led1;
}


//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------
int main(void)
{
    
    printf("\r\n\n\n\n-----\r\nI'm alive - vers. uAXIS - accelerometer testing\r\n\n");
    
    // POWER MANAGEMENT
    printf("\nShut down ethernet interface.\r\n");
    PHY_PowerDown();    // Turn off the ethernet interface; -175mW
    
    C027 thisBoard;
    printf("Disable GPS power supply.\r\n\n");
    thisBoard.gpsPower(false);      // Turn off the GPS power supply
    
    


/*
    MDMSerial mdm;
    MDMParser::DevStatus devStatus = {};
    MDMParser::NetStatus netStatus = {};
    bool mdmOk = mdm.init(SIMPIN, &devStatus);
    
    #ifdef MDMDEBUG
        mdm.setDebug(4);
    #endif
    
    // ----------------
    // LOCATION READING
    
    
    // OPEN MODEM CONNECTION
    if (!mdm.connect(SIMPIN, APN,USERNAME,PASSWORD))
        return -1;
    
    // SET DEEP SCAN MODE
    printf("Configure deep scan mode\r\n");
    int locConf = mdm.cellLocConfigSensor(1);
    
    
    // Cell location data
    MDMSerial::CellLocData thisLoc;
    
    */
    
    // Location loop driving variables
    int loopIter = 0;
    bool sendStatus = false;
    
    // Loop timing variables
    Timer cellLocDelay;
    
    int cellLocPeriod = 30; // in seconds
    int timeoutMargin = 5;  // in seconds

    
    // Location data filter variables
    int locAccLower = 50;   // Immediately accept locations with uncertainty lower than this
    int locAccUpper = 5000; // Don't accept locations with uncertainty greater than this
    
    // Filter counters
    int fail1count = 0;
    int fail2count = 0;
    int fail3count = 0;


    // Cell location call variables
    const int sensorMask = 2;  // 1 = GNSS, 2 = CellLocate (aka cell grid position info), 3 = Hybrid: GNSS + CellLocate
    int cellLocReqTimeout = cellLocPeriod - timeoutMargin;  // in seconds       
    const int targetAccuracy = 1; // in meters
    
    I2C axis(P0_0, P0_1);
    delay(5000);
    
    // -----------------------
    // Location reporting loop
    while(true) {
        
        // Set some important variables
        M2X_response = 0;
        sendStatus = 0;
        loopIter++;
        
        //printf("tick\r\n");
        
        
        
        // Let's play with the accelerometer (STM LIS331)
        
        printf("LIS331 experiments\r\n\n");
        
        axis.frequency(400000);     // in Hz
        
        int whowho;
        int I2Cret;
        
        int axWrite = 0x3A;
        int axRead = 0x3B;
        
        int axConf1 = 0x20;
        int axWho = 0x0f;
        
        
        printf("T-minus 1 second...\r\n");
        delay(1000);
        
        // RAW WHOAMI

        axis.start();
        if(axis.write(axWrite))
            printf("Write ACK\r\n");
        axis.write(axWho);
        axis.start();
        if(axis.write(axRead))
            printf("Write ACK\r\n");
        whowho = axis.read(1);
        axis.stop();
        printf("raw WhoAmI = 0x%02x\r\n\n", whowho);   

        // RAW config1 set
        printf("Set CONFIG1 to 0xC7\r\n");
        axis.start();
        if(axis.write(axWrite))
            printf("Write ACK\r\n");
        if(axis.write(axConf1))
            printf("Write ACK\r\n");
        axis.write(0xC7);
        axis.stop();
        
        
        // RAW config1 read
        axis.start();
        if(axis.write(axWrite))
            printf("Write ACK\r\n");
        axis.write(axConf1);
        axis.start();
        if(axis.write(axRead))
            printf("Write ACK\r\n");
        I2Cret = axis.read(1);
        axis.stop();
        printf("raw config1 = 0x%02x\r\n", I2Cret);

        
        
        // RAW WHOAMI
        axis.start();
        if(axis.write(axWrite))
            printf("Write ACK\r\n");
        axis.write(axWho);
        axis.start();
        if(axis.write(axRead))
            printf("Write ACK\r\n");
        whowho = axis.read(1);
        axis.stop();
        printf("post-CONFIG1 raw WhoAmI = 0x%02x\r\n", whowho);      
        
      
        // RAW config1 read
        axis.start();
        if(axis.write(axWrite))
            printf("Write ACK\r\n");
        axis.write(axConf1);
        axis.start();
        if(axis.write(axRead))
            printf("Write ACK\r\n");
        I2Cret = axis.read(1);
        axis.stop();
        printf("raw config1 = 0x%02x\r\n", I2Cret);   
        
        printf("-- LOOP END --\r\n\n");
        
        break;
        
    }


    //mdm.disconnect();
    //mdm.powerOff();
    
}
