// PONY_Loc.h
// Location code for PONY
// (C) 2015 Igor Institute

# include "GPS.h"

struct GPSbundle {
    GPSI2C bGPS;    // Pointer to our GPS item
    int bRet;
    int bLen;
    char* bBuf;
    int bBufLen;
};

struct GPSloc {
    double tmstmp;
    double lat;
    double lon;
    double alt;
    double vel;
};

struct moveData {
    int16_t x;
    int16_t y;
    int16_t z;
};

int readyGPS(GPSbundle*, int);
int getNMEAtalker (const char*);

int fetchLocBundle(GPSbundle*, GPSloc*, int);

int fillLocBundle(GPSbundle*, GPSloc*);



int fetchLaLo(GPSbundle*, GPSloc*, int);
int verifyGLL(GPSbundle*, GPSloc*);

int fetchAlt(GPSbundle*, GPSloc*, int);

void parseM2XLocation(const char*, double, double, const char*, int, void*);


void getFormattedTime(time_t*, tm*);


//int verify