#include "mbed.h"
#include <iostream>
#include <map>
#include <string>
#include <stdio.h>

//Class PwmIn taken from http://mbed.org/forum/mbed/topic/466/?page=1#comment-2457   User: Simon Ford

I2C i2c1(p28, p27); // SDA, SCL
I2C i2c2(p9, p10); // SDA, SCL
float input1=0;
float input2=0;
const int addr_W = 0xC4; // Address to write
bool autom=false;
Serial pc(USBTX, USBRX);

DigitalInOut manual(p24);
Timeout to1;
int val=0;

void write1(float v) { // 0 < v < 3.3 V
    char H;      // High byte
    char L;      // Low byte
    int n;
    n = (int)(v*4096/5);
    H = n>>4;
    L = (n<<4 & 0xF0);

    
    i2c1.start();
    i2c1.write(addr_W); // Write address to write
    i2c1.write(0x40);   // Write command
    i2c1.write(H);      // Write high byte
    i2c1.write(L);      // Write low byte
    i2c1.stop();
}

void write2(float v) { // 0 < v < 3.3 V
    char H;      // High byte
    char L;      // Low byte
    int n;
    n = (int)(v*4096/5);
    H = n>>4;
    L = (n<<4 & 0xF0);
    
    i2c2.start();
    i2c2.write(addr_W); // Write address to write
    i2c2.write(0x40);   // Write command
    i2c2.write(H);      // Write high byte
    i2c2.write(L);      // Write low byte
    i2c2.stop();
}

class PwmIn {
public:
    PwmIn(PinName p) : _p(p) {
        _p.rise(this, &PwmIn::rise);
        _p.fall(this, &PwmIn::fall);
        _period = 0.0;
        _pulsewidth = 0.0;
        _t.start();
    }
    
    void rise() {
        _period = _t.read();
        _t.reset();
    }
    
    void fall() {
        _pulsewidth = _t.read();
    }
    
    float period() { return _period; }
    float pulsewidth() { return _pulsewidth; }
    float dutycycle() { return _pulsewidth / _period; }

protected:        
    InterruptIn _p;
    Timer _t;
    float _pulsewidth, _period;
};


PwmIn a(p5);
PwmIn b(p6);

void manual_overide(void){
    //printf("a: pw = %f, period = %f, Part of 100= %f \r\n", a.pulsewidth()*100, a.period()*100, (a.pulsewidth()*100-.1)*10);
    //printf("b: pw = %f, period = %f, Part of 100= %f \r\n", b.pulsewidth()*100, b.period()*100, (b.pulsewidth()*100-.1)*10);
    
    float new_f = ((b.pulsewidth()*100-.1)*10)-.5;
    //printf("this is the turning: %f \r\n", new_f);
    float new_L = ((a.pulsewidth()*100-.1)*10-new_f)*5;
    float new_R=((a.pulsewidth()*100-.1)*10+new_f)*5;
    
    if (new_L>5.0){
        new_L=4.9;
        }
    if (new_R>5.0){
        new_R=4.9;
        }
    if (new_R<0){
        new_R=0.2;
        }
    if (new_L<0){
        new_L=0.2;
        }
    //printf("this is the right wheel: %f \r\n", new_R);
    //printf("this is the left wheel: %f \r\n", new_L);
    write1(new_R);
    write2(new_L);
  
    }


void automatic(void) {

        char c;
        char buffer[128];
        if (pc.readable()){
        pc.gets(buffer,20);
        char vone[4]={buffer[0],buffer[1],buffer[2]};
        char vtwo[4]={buffer[4],buffer[5],buffer[6]};
        float first=atof(vone);
        float second=atof(vtwo);
        float new_L=first*5;
        float new_R=second*5;
        f (new_L>5.0){
        new_L=4.9;
        }
    if (new_R>5.0){
        new_R=4.9;
        }
    if (new_R<0){
        new_R=0.2;
        }
    if (new_L<0){
        new_L=0.2;
        }
//        printf("Pushing back: %f \r\n",first);
        write1(new_R);      
        write2(new_L);
        }
         
}



Ticker ticker;
DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can2(p30, p29);
char counter[8] = {1,1,1,1,1,1,1,1};
int test=0x0;
char counter2=0;





void sending_values(long int int1,long int int2,long int int3,long int int4, int ID )
{
    //val();
    counter[0]=int1 >> 8;
    counter[1]=int1 & 0xFF;
    counter[2]=int2 >> 8;
    counter[3]=int2 & 0xFF;
    counter[4]=int3 >> 8;
    counter[5]=int3 & 0xFF;
    counter[6]=int4 >> 8;
    counter[7]=int4 & 0xFF;
    
    if(can2.write(CANMessage(ID, counter, 8))) {
  
        //printf("Message sent: %x%x\r\n", counter[1],counter[0]);
        //printf("Should be: %d, %d, %d, %d\r\n", int1,int2,int3,int4);
}
}


 

void Can_main(bool send, long int val1,long int val2,long int val3,long int val4, int the_ID) {

    
        
    std::map <int,string> CanIDMap;

    CanIDMap[0]="Motor Controller String";
    CanIDMap[1]="Motor Controller Ints";
    CanIDMap[2]="Power Controller Voltage_Battery";
    CanIDMap[3]="Power Controller Voltage_5V";
    CanIDMap[4]="Power Controller Voltage_12V";
    CanIDMap[5]="Power Controller Voltage_Motor";
    CanIDMap[6]="Power Controller Current_Battery";
    CanIDMap[7]="Power Controller Current_5V";
    CanIDMap[8]="Power Controller Current_12V";
    CanIDMap[9]="Power Controller Current_Motor";
    CanIDMap[10]="LCD Controller String";
    CanIDMap[11]="LCD Controller Ints";
    CanIDMap[12]="Zac is the Best";
    CanIDMap[13]="Automatic Control";
    CanIDMap[14]="Manual Control";

    
    
    //ticker.attach(&sending_values,1);
    CANMessage msg;
    int fixer1=0;
    int fixer2=0;
    int fixer3=0;
    int fixer4=0;
    
        if (send==true){
        sending_values(val1,val2,val3,val4,the_ID);
            
        }
        
        if(can2.read(msg)) {
            bool tester= CanIDMap.find(msg.id) != CanIDMap.end();
            if (tester){
            //printf("Message received: %x %x \r\n", msg.data[0], msg.data[1]);
           
            //printf("ID of message: %s \r\n", CanIDMap[msg.id]);
            
            std::string str=CanIDMap[msg.id];
            unsigned pos = str.find("_");         // position of "_" in str
            std::string str3 = str.substr (pos+1);     // get from past"_" to the end
            //printf("Dealing with: %s \r\n",str3);
            fixer1=((msg.data[0]<<8) | (msg.data[1]));
            fixer2=((msg.data[2]<<8) | (msg.data[3]));
            fixer3=((msg.data[4]<<8) | (msg.data[5]));
            fixer4=((msg.data[6]<<8) | (msg.data[7]));
            led2 = !led2;
            
            //printf("Resulting Answer back is: %d, %d, %d, %d\r\n\r\n\r\n",fixer1,fixer2,fixer3,fixer4 );
            if (CanIDMap[msg.id]=="Automatic Control"){
                autom=true;
                }
            if (CanIDMap[msg.id]=="Manual Control"){              
                autom=false;
                }
                
        } 
        
        else{
        
        //printf("Can Message, not related to this controller\r\n\r\n");
        
        }
        
    }
    }
 





    


int main(){
    can2.frequency(500000);
    
    while(1){
    Can_main(false,15,84,1254,3254,1);
    if (autom==false)
    {
        manual_overide();
       }
    else{
        automatic();
        
        }
        
    }
}
