#include "mbed.h" // libraries
#include "tsi_sensor.h"

#define ELEC0 9 // these are the pin numbers for capacitive touch
#define ELEC1 10

Serial pc(USBTX, USBRX); // configure UART pins
int main()
{
    pc.baud(9600);  //Set baud rate for UART module
    int sliderValue = 0; // holder variable
    TSIAnalogSlider tsi(ELEC0, ELEC1, 40); // configure capacitive (CT) touch pins
    while (true) { // loop forever
        wait(0.1f); // wait a small period of time
        pc.printf("Touch Value is: %d\r\n", sliderValue); // print the value
        sliderValue = (char)(256 * tsi.readPercentage());; // get value from CT
    }
}
