#include "mbed.h"
 
SPISlave spi(PTD2, PTD3, PTD1, PTD10); // mosi, miso, sclk, cs
Serial pc(USBTX, USBRX); // Configure UART
PwmOut g_led(LED_GREEN); // Configure Green LED
 
int main() {
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);
    // Configure PC/Serial Connection
    pc.baud(9600);
    
    while(1)
    {
        char receivedValue = 0;
        if(spi.receive()) { //Poll SPI module to see if a byte has been received
            receivedValue = spi.read(); // Read Received value
            if(receivedValue != 0x00) {
                spi.reply(receivedValue); // Set reply when next byte is received
                pc.printf("Received Data = 0x%X\n\r",receivedValue); // Output to PC Serial
                g_led = 1.0f * receivedValue; // Set Green LED to be percentage value
            }
        }
    }
}
