#include "mbed.h"
#include "tsi_sensor.h"
#define ELEC0 9    // Pin connections for touch sensor
#define ELEC1 10
 
SPI spi(PTD2, PTD3, PTD1); // mosi, miso, sclk
DigitalOut cs(PTD0);
TSIAnalogSlider tsi(ELEC0, ELEC1, 40);
Serial pc(USBTX, USBRX); // Configure PC UART
 
int main() {
    
    // Configure PC/Serial Connection
    pc.baud(9600);
    char slidervalue = 0;
    char responsevalue = 0;
    // Chip must be deselected
    cs = 1;
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,3);
    spi.frequency(1000000);
 
    while(true) {        
        slidervalue = (char)(254 * tsi.readPercentage() + 1); // Get value from Cap. Touch
        cs = 0; // Select the device by seting chip select low
        spi.write(slidervalue); // Send slider percentage in a single byte
        responsevalue = spi.write(0x00); // Send slider percentage in a single byte
        pc.printf("LED Adjusted to = 0x%X\n\r", responsevalue); // Print to PC/Serial
        // Deselect the device
        cs = 1;
    }
}