#include "mbed.h"
#include "OB1203.h"
#include "math.h"

//normal
I2C i2c(I2C_SDA,I2C_SCL); //instantiate an i2c object from its class
#define intb_pin D3

//slave board//
//I2C i2c(D12,PA_7);
//#define intb_pin D10

InterruptIn intb(intb_pin); //declare an interrupt pin for INTB

//setting three 3 pins high to function as pullups for SDA, SCL and INTB
// these pins to SDA, SCL and INTB by 2.7K resistors.
//5K resistors also work usually
//DigitalOut sda_pullup(D10,1); 
//DigitalOut scl_pullup(D11,1);
//DigitalOut intb_pullup(D12,1);

OB1203 ob1203(&i2c); //instantiate the OB1203 object from its class and pass i2c object
Serial pc(USBTX, USBRX,256000); //create a serial port for printing data to a pc
//Serial pc(USBTX, USBRX,115200); //create a serial port for printing data to a pc
Timer t; //use a microsecond timer for time stamping data


//USER CONFIGURABLE*********
bool mode = 1; //0 for PS_LS, 1 for PPG
bool meas_ps = 1;
bool spo2 = 1; //0 for HR, 1 for SpO2
bool afull = 1; //use Afull interrupt--otherwise PPG new data interrupt
bool meas_temp = 0;
bool printAvg = 0; //default 0 print raw data
bool redAGC = 1;
bool irAGC = 1;
bool trim_oscillator = 0;
bool printCurrent = 1;
bool turn_off_prox_trim = 1;
//***************************

//internal settings
bool intFlagged =0;
int sample_delay = 25; //ms

void defaultConfig() //populate the default settings here
{
    //high accuracy oscillator trim overwrite option
    ob1203.osc_trim = 0x3F; //max trim code =0x3F
    //temperature sensor settings (hidden registers)
    meas_temp ? ob1203.temp_en = TEMP_ON : ob1203.temp_en = TEMP_OFF;
    //LS settings
    ob1203.ls_res = LS_RES(2); //2= 18bit 100ms, 0= max res
    ob1203.ls_rate = LS_RATE(2); //2 =100ms, 4 = 500ms
    ob1203.ls_gain = LS_GAIN(3); //gain 3 default (range)
    ob1203.ls_thres_hi = 0x000FFFFF;
    ob1203.ls_thres_lo = 0;
    ob1203.ls_sai = LS_SAI_OFF;
    ob1203.ls_mode = RGB_MODE;
    ob1203.ls_en = LS_ON;
    //PS and PPG settings
    ob1203.ps_sai_en = PS_SAI_OFF;
//    ob1203.ps_sai_en = PS_SAI_ON;
    if(mode)
    {
        spo2 ? ob1203.ppg_ps_mode = SPO2_MODE : ob1203.ppg_ps_mode = HR_MODE;    
    }
    else
    {
        ob1203.ppg_ps_mode = PS_MODE;
    }
    if (turn_off_prox_trim) {
        ob1203.led1_trim = 0;
        ob1203.led2_trim = 0;
    }
    ob1203.ps_pulses = PS_PULSES(3);
//    pc.printf("ps_pulses = %02X\r\n",ob1203.ps_pulses);
    ob1203.ps_pwidth = PS_PWIDTH(1);
    ob1203.ps_rate = PS_RATE(4);
//    pc.printf("ps_rate = %02X\r\n",ob1203.ps_rate);
    ob1203.ps_avg_en = PS_AVG_OFF;
    ob1203.ps_can_ana = PS_CAN_ANA_0;
    ob1203.ps_digital_can = 150;
    ob1203.ps_hys_level = 0;
    meas_ps ? ob1203.ps_current = 0x1FF : ob1203.ps_current = 0x000;
//    ob1203.ps_current = 0;
    ob1203.ps_thres_hi = 0xFF;
    ob1203.ps_thres_lo = 0x00;
    
    //interrupts
    ob1203.ls_int_sel = LS_INT_SEL_W;
    ob1203.ls_var_mode = LS_THRES_INT_MODE;
    ob1203.ls_int_en = LS_INT_ON;
    ob1203.ppg_ps_en = PPG_PS_ON;

    mode ? ob1203.ps_logic_mode = PS_INT_READ_CLEARS : ob1203.ps_logic_mode = PS_INT_LOGIC;
    ob1203.ps_int_en = PS_INT_ON;
    ob1203.ls_persist = LS_PERSIST(2);
    ob1203.ps_persist = PS_PERSIST(2);
    
    
    //BIO SETTINGS
    //int
    if(afull)
    {
        ob1203.afull_int_en = AFULL_INT_ON;
        ob1203.ppg_int_en = PPG_INT_OFF;
    }
    else
    {     
        ob1203.afull_int_en = AFULL_INT_OFF;
        ob1203.ppg_int_en = PPG_INT_ON;
    }
    //PPG
    ob1203.ir_current = 0x0F; //max 1023. 3FF
    if (spo2)
    {
//        ob1203.r_current = 0x0FF;
    ob1203.r_current = 0x07; //max 511. 1FF
    }
    else 
    {   
        ob1203.r_current = 0;
    }
    
    ob1203.ppg_ps_gain = PPG_PS_GAIN_1;
    
    ob1203.ppg_pow_save = PPG_POW_SAVE_OFF;
    ob1203.led_flip = LED_FLIP_OFF;
    //ob1203.led_flip = LED_FLIP_ON;
    ob1203.ch1_can_ana = PPG_CH1_CAN(0);
    ob1203.ch2_can_ana = PPG_CH2_CAN(0);
    //use rate 1 with pulse width 3 and average 4, or rate 3 with pulse width 4 and average 3 for 100 sps (50Hz basis) or 120 sps sample rate (60Hz basis)
    
    
    //DEBUGGING******************************************************
    //ob1203.ppg_avg = PPG_AVG(0);
    ob1203.ppg_avg = PPG_AVG(4); //2^n averages
    
    //DEGUGGING*****************************************************
    ob1203.ppg_rate = PPG_RATE(1); 
    //ob1203.ppg_rate = PPG_RATE(6);
    
    ob1203.ppg_pwidth = PPG_PWIDTH(3);
//    ob1203.ppg_freq = PPG_FREQ_50HZ;
    ob1203.ppg_freq = PPG_FREQ_PRODUCTION;
    ob1203.bio_trim = 3; //max 3 --this dims the ADC sensitivity, but reduces noise
    ob1203.led_trim = 0x00; //can use to overwrite trim setting and max out the current 
    ob1203.ppg_LED_settling = PPG_LED_SETTLING(2); //hidden regstier for adjusting LED setting time (not a factor for noise)
    ob1203.ppg_ALC_track = PPG_ALC_TRACK(2); //hidden register for adjusting ALC track and hold time (not a factor for noise)
    ob1203.diff = DIFF_ON; //hidden register for turning off subtraction of residual ambient light after ALC
    ob1203.alc = ALC_ON;  //hidden register for turning off ambient light cancelleation track and hold circuit
    ob1203.sig_out = SIGNAL_OUT; //hidden register for selecting ambient sample or LED sample if DIFF is off
    ob1203.fifo_rollover_en = FIFO_ROLL_ON;
    ob1203.fifo_afull_advance_warning = AFULL_ADVANCE_WARNING(0x0F); //warn as quickly as possible (after 17 samples with 0x0F)
    
    //run initialization according to user compile settings

    if(mode)
    {
        if(spo2)
        {
            ob1203.init_spo2();
        }
        else
        {
            ob1203.init_hr();
        }
    }
    else    
    {
       meas_ps ? ob1203.init_ps_rgb() : ob1203.init_rgb();
    }
    if(trim_oscillator)
        ob1203.setOscTrim();
    
}

void regDump(uint8_t Addr, uint8_t startByte, uint8_t endByte)
{
    /*print the values of up to 20 registers--buffer limit, e.g.*/
    char regData[20];
    int numBytes;
    if (endByte>=startByte) {
        numBytes =  (endByte-startByte+1) < 20 ? (endByte-startByte+1) : 20;
    } else {
        numBytes=1;
    }

    regData[0] = startByte;
    i2c.write(Addr,regData,1,true);
    i2c.read(Addr, regData, numBytes);
    for(int n=0; n<numBytes; n++) {
        pc.printf("%02X, %02X \r\n", startByte+n, regData[n]);
    }
}


void intEvent(void)
{
    intFlagged = 1;
}

int main() 
/*This program is messy bacause it allows several different print options and interrupt modes
Most of the variables are associated with an optional FIR filter to make data pretty.
*/
{
    int numInts = 0;
    uint32_t running_avg = 10;
    uint32_t ps_running_avg = 100;
    uint32_t ps_avg_ptr = 0;
    char avg_ptr = 0;
    int baseline_ptr = 0;
    uint32_t running_baseline = 240;
    int first = 1;
    uint32_t IRavg = 0;
    uint32_t Ravg = 0;
    uint32_t IRprev = 0;
    uint32_t Rprev = 0;
    uint32_t prevAvg = 0;
    uint32_t IR_avg_buffer[running_avg];
    uint32_t R_avg_buffer[running_avg];
    uint32_t IR_baseline_buffer[running_baseline];
    uint32_t R_baseline_buffer[running_baseline];
    uint32_t IRbaseline_prev=0;;
    uint32_t Rbaseline_prev=0;;
    uint32_t IRbaseline=0;
    uint32_t Rbaseline=0;
    uint32_t prevBaseline=0;
    uint32_t PSavg = 0;
    uint32_t PSprev = 0;
    uint32_t PS_avg_buffer[ps_running_avg];
    
    bool update = 0;


    for (int n=0;n<ps_running_avg;n++)
    {
        PS_avg_buffer[n] =0;
    }
    
    i2c.frequency( 400000 ); //always use max speed I2C
    char valid;
    uint32_t ps_ls_data[7]; //array for storing parsed samples
    char samples2Read = 2; //FIFO samples, e.g. 4 samples * 3 bytes = 12 bytes (or 2 SpO2 samples)
    char fifoBuffer[samples2Read*3];
    uint32_t ppgData[samples2Read];  

    
    pc.printf("register settings\r\n");
    regDump(OB1203_ADDR,0,19);
    regDump(OB1203_ADDR,20,39);
    regDump(OB1203_ADDR,40,59);
    regDump(OB1203_ADDR,60,77);
    
    pc.printf("do initial config\r\n");
    defaultConfig(); //do the ASIC configuration now
    
    pc.printf("print new register config\r\n");
    regDump(OB1203_ADDR,0,19);
    regDump(OB1203_ADDR,20,39);
    regDump(OB1203_ADDR,40,59);
    regDump(OB1203_ADDR,60,77);
    
        
    intb.fall(&intEvent); //attach a falling interrupt
    t.start(); //start microsecond timer for datalogging

    while(1)
    {
        if(mode) //PPG case*******************************************************
        {
            if(!intb.read()) //check the intb to see if it is low (or could check variable set by ISR here)
            {
                if(!afull) //if you are using sample completion interrupts
                {
                    numInts++; //increment counter to get data every so many interrupts if ppg new data interrupt mode
                }
                else
                {
                    numInts = samples2Read;
                }
                intFlagged = 1;
                if( (numInts < samples2Read) && !afull)
                {
                    ob1203.get_status(); //clear interrupt--not time to get data yet
                }
                else if(intFlagged && (numInts==samples2Read) ) //time to get data
                {
                    numInts = 0;
                    ob1203.getFifoSamples(samples2Read,fifoBuffer);
    //                for (int n=0;n<samples2Read*3;n++)
    //                {
    //                    pc.printf("%02X ",fifoBuffer[n]);
    //                }
    //                pc.printf("\r\n");
                    ob1203.parseFifoSamples(samples2Read,fifoBuffer,ppgData);
    //                for (int n=0;n<samples2Read;n++)
    //                {
    //                    pc.printf("%d ",ppgData[n]);
    //                }
    //                pc.printf("\r\n");
                    if(first) //populate average and baseline buffers the first time we run
                    {
                        for(int n=0;n<running_avg;n++)
                        {
                            IR_avg_buffer[n] = ppgData[0];
                            IRavg += IR_avg_buffer[n];
                            if(spo2)
                            {
                                R_avg_buffer[n] = ppgData[1];
                                Ravg += R_avg_buffer[n];
                            }
                            
                        }
                        for( int n=0;n<running_baseline;n++)
                        {
                            IR_baseline_buffer[n] = 0;
                            if(spo2)
                            {
                                 R_baseline_buffer[n] = 0;
                            }
                        }
                        first = 0;
                    }//end if first
                                 
                    for (int n=0;n<samples2Read/2;n++)
                    {
                        ( avg_ptr+1 == running_avg ) ? avg_ptr = 0 : avg_ptr++;
                        ( baseline_ptr+1 == running_baseline) ? baseline_ptr = 0 : baseline_ptr++;
                        IRprev = IR_avg_buffer[avg_ptr]; //load the sample you are about to write over
                        IR_avg_buffer[avg_ptr] = ppgData[2*n]; //load the new sample in the buffer
                        IRavg += (IR_avg_buffer[avg_ptr] - IRprev); //update the average by removing the old sample and adding the new
                        
                        IRbaseline_prev = IR_baseline_buffer[baseline_ptr]; //load the sample you are about to write over
                        IR_baseline_buffer[baseline_ptr] = ppgData[2*n]; //load the new sample in the buffer
                        IRbaseline += (IR_baseline_buffer[baseline_ptr] - IRbaseline_prev); //update the average by removing the old sample and adding the new
                        
                        if(spo2) //print two columsn of data
                        {
                            Rprev = R_avg_buffer[avg_ptr];
                            R_avg_buffer[avg_ptr] = ppgData[2*n+1];
                            Ravg += (R_avg_buffer[avg_ptr] - Rprev);
                           
    //                        pc.printf("%d, %d, %d, %d\r\n",IRavg/running_avg,Ravg/running_avg, IR_avg_buffer[avg_ptr],R_avg_buffer[avg_ptr]);
    
                            Rbaseline_prev = R_baseline_buffer[baseline_ptr];
                            R_baseline_buffer[baseline_ptr] = ppgData[2*n+1];
                            Rbaseline += (R_baseline_buffer[baseline_ptr] - Rbaseline_prev);
                            
                            if(printAvg) 
                            {
                            //PRINT AVG DATA
                                pc.printf("%d,%d,%d\r\n",t.read_us(),IRavg/running_avg,Ravg/running_avg);
                                //pc.printf("%d,%d\r\n",IRavg/running_avg,Ravg/running_avg);
//                            pc.printf("%d,%d\r\n",IRavg/running_avg-IRbaseline/running_baseline, Ravg/running_avg-Rbaseline/running_baseline);
//                            pc.printf("%d,%d,%d,%d\r\n",Ravg/running_avg,Rbaseline/running_baseline,Rbaseline_prev,Ravg/running_avg-Rbaseline/running_baseline);
                            }
                            else
                            {
                                //PRINT RAW DATA
                                if(printCurrent)
                                {
                                    pc.printf("%d, %d, %d, %d, %d\r\n",t.read_us(),ppgData[2*n],ppgData[2*n+1],ob1203.ir_current,ob1203.r_current); //print with us counter time stamp (use only with slower data rates or averaging as this slows down the data printing);
                                }
                                else
                                {
                                    pc.printf("%d, %d, %d\r\n",t.read_us(),ppgData[2*n],ppgData[2*n+1]); //print with us counter time stamp (use only with slower data rates or averaging as this slows down the data printing);
//                             pc.printf("%d, %d\r\n",ppgData[2*n],ppgData[2*n+1]); //print without us timer (faster)
                                }
                            }
                        }//end SpO2 case
                        else //HR mode print one column of data
                        {
                            ( avg_ptr+1 == running_avg ) ? avg_ptr = 0 : avg_ptr++;
                            ( baseline_ptr+1 == running_baseline) ? baseline_ptr = 0 : baseline_ptr++;
                            IRprev = IR_avg_buffer[avg_ptr];
                            IR_avg_buffer[avg_ptr] = ppgData[2*n+1];
                            prevAvg = IRavg;
                            IRavg += (IR_avg_buffer[avg_ptr] - IRprev);
                            
                            IRbaseline_prev = IR_baseline_buffer[baseline_ptr]; //load the sample you are about to write over
                            IR_baseline_buffer[baseline_ptr] = ppgData[2*n]; //load the new sample in the buffer
                            prevBaseline = IRbaseline;
                            IRbaseline += (IR_baseline_buffer[baseline_ptr] - IRbaseline_prev); //update the average by removing the old sample and adding the new


                            if(printAvg)
                            {
                            //PRINT AVG DATA
                                pc.printf("%d\r\n%d\r\n",prevAvg/running_avg-prevBaseline/running_baseline,IRavg/running_avg-IRbaseline/running_baseline);
                            }
                            else
                            {
                            //PRINT RAW DATA
                                pc.printf("%d\r\n%d\r\n",ppgData[2*n],ppgData[2*n+1]);
//                          pc.printf("%d, %d, %d\r\n",t.read_us(),ppgData[2*n],ppgData[2*n+1]); //print with us counter time stamp (use only with slower data rates or averaging as this slows down the data printing);                   
                                
                            }
                        }//HR case
                        if(n+1==samples2Read/2)
                        {
                            if(irAGC)
                            {
                                ob1203.do_agc(ppgData[2*n],0);  
                            }//end IR AGC case
                            if(spo2 && redAGC)
                            {
                                ob1203.do_agc(ppgData[2*n+1],1);  
                            }//enr R AGC case
                            if(ob1203.update)
                            {
                                ob1203.setPPGcurrent();
                                ob1203.resetFIFO();
                                ob1203.update=0;
                            }
                        }
                    }//end sample loop
                    
                    
                    
                    intFlagged = 0;
                
                 }//end if time to read samples             
            } //end if !intb
        }// end mode (PPG case)
        //*********************************************************************
        else //LS and PS measurement case
        {
            wait_ms(sample_delay);
            if( meas_ps ? ob1203.psIsNew() : ob1203.lsIsNew() )
            {
                meas_ps ? valid = ob1203.get_ps_ls_data(ps_ls_data) : valid = ob1203.get_ls_data(ps_ls_data);
                if(meas_ps)
                {
                    ( ps_avg_ptr+1 == ps_running_avg ) ? ps_avg_ptr = 0 : ps_avg_ptr++;
                    PSprev = PS_avg_buffer[ps_avg_ptr]; //load the sample you are about to write over
                    PS_avg_buffer[ps_avg_ptr] = ps_ls_data[0]; //load the new sample in the buffer
                    PSavg += (PS_avg_buffer[ps_avg_ptr] - PSprev); //update the average by removing the old sample and adding the new
//                    pc.printf("%d %d %d %d %d ",ps_avg_ptr, PSprev, PS_avg_buffer[ps_avg_ptr],ps_ls_data[0],PSavg);
                }
                if (meas_temp) 
                {
                    ob1203.setMainConfig();
                }
                pc.printf("%d, %d %d %d %d %d\r\n",ps_ls_data[0],ps_ls_data[1],ps_ls_data[2],ps_ls_data[3],ps_ls_data[4],ps_ls_data[5]);
//                pc.printf("%d, %d %d %d %d %d %d %d\r\n",(PSavg/ps_running_avg),ps_ls_data[0],ps_ls_data[1],ps_ls_data[2],ps_ls_data[3],ps_ls_data[4],ps_ls_data[5],ps_ls_data[6]);
            
            }
//            else
//            {
//                pc.printf("status = %04X\r\n",ob1203.get_status() );
//            }
        }
    }//end while
}//end main