#include "mbed.h"
#include "LIS3DH.h"
#include "FSR.h"
#include "USBMouseKeyboard.h"
#include <string>
#include <math.h>
//Using MMA8452 accelerometer. SDA on 28, SCL on 27. Writes gravities to the screen. 
//Also brightens/dims LEDs 1-3 based on whether or not they are 'level'( 0 Gs)

Serial pc(USBTX,USBRX);
USBMouseKeyboard controller;

LIS3DH acc(D7, D6, LIS3DH_G_CHIP_ADDR);
FSR fsr(PTB3, 100);

DigitalIn d8(D8);
DigitalIn d9(D9);

PwmOut red(LED1);
PwmOut blue(LED3);

float data[3];
double x, y, z;
static const float Width = (float)(X_MAX_ABS - X_MIN_ABS);
#ifndef M_PI
#define M_PI           3.14159265358979323846
#endif

string translate(double x, double y, double z) {
    double val = atan(x/y);
    if (x < 0 && abs(val) >= 0.6)               return "Hard Left";
    else if (x < 0 && val < 0.6 && val > 0.2)   return "Soft Left"; 
    else if (x > 0 && abs(val) >= 0.6)          return "Hard Right"; 
    else if (x > 0 && val > -0.6 && val < -0.2) return "Soft Right";
    else                                        return "Straight";
}

int16_t calculate_mouse_x(double x, double y) {
    double val = atan(x/y);
    if (abs(val) < 0.2) return 0;
    if (x < 0) {
        return Width * (-abs(val)/M_PI)/256;
    } else {
        return Width * (abs(val)/M_PI)/256;
    }
}

void holdA() {
    int i = (int) floor(fsr.readRaw()*100) ;
    while (i > 0) {
        controller.keyCode('a', 0);
        i--;   
    }
}

int main() {    
    pc.printf("Starting program...\r\n");
    while(1) {
        acc.read_data(data);
        x = data[0]; y = data[1]; z = data[2];
        //pc.printf("x:%lf   y:%lf   z:%lf\r\n",x,y,z);
        //pc.printf("Detect as: %s \r\n", translate(x, y, z));
        //pc.printf("dX:%d \r\n", calculate_mouse_x(x, y));
        /*
        if (!d8) {
            controller.keyCode('a', 0);
            controller.keyCode('a', 0);
            controller.keyCode('a', 0);
        }
        */
        if (!d9) controller.move(calculate_mouse_x(x, y), 0);
        /*
        if (!d8) {
            controller.keyCode('a', 0);
            controller.keyCode('a', 0);
            controller.keyCode('a', 0);
        }
        */
        
        holdA();
        
        //wait(0.01f);
        //wait(2);
    }
}