#include "mbed.h"
#include "ultrasonic.h"
#include "Dht11.h"
#include <stdio.h>
Serial pc(USBTX, USBRX); // tx, rx

// pull down
DigitalIn b1(D9);
DigitalIn b2(D8);
DigitalIn b3(D7);
DigitalIn b4(D6);
DigitalIn b5(D5);
DigitalIn b6(D4);
DigitalIn b7(D3);
DigitalIn b8(D2); 

Dht11 tmpSensor(D0);

DigitalIn buttons[8]={b1,b2,b3,b4,b5,b6,b7,b8};
int buttonNames[] = {1,2,3,4,5,6,7,8};


// values for temp/humidity sensor;
int tempSamples[5];
int humiSamples[5];
int counter = 0;

int tempValue = 0;
int minTemp = 0;

int humiValue = 0;
int minHumi = 0;

float findMedian(int x[]) {
    float temp;
    int i, j;
    // the following two loops sort the array x in ascending order
    for(i=0; i < 4; i++) {
        for(j=i+1; j<5; j++) {
            if(x[j] < x[i]) {
                // swap elements
                temp = x[i];
                x[i] = x[j];
                x[j] = temp;
            }
        }
    }
    return x[2];
} 



void averageTH(int temperature, int humidity) {
    if (counter==5){
        counter=0; 
        int medTemp = findMedian(tempSamples);
        int medHumi = findMedian(humiSamples);
        if (medTemp >= minTemp && medHumi >= minHumi) {
            tempValue =  medTemp;
            humiValue = medHumi;
            printf("tmp %d\r\n", tempValue); 
            printf("hum %d\r\n", humiValue);
        }
        
    } else {
        tempSamples[counter] = temperature;
        humiSamples[counter] = humidity;
        counter += 1;
        //printf("Temperature changed to %dmm\r\n", temperature);
    }

   

}

void waitforbuttons() {
    for (int i = 0; i < 8; i++) {
        DigitalIn button = buttons[i];
        int name = buttonNames[i];
        if (button.read() == 0) {
            pc.printf("button %d\r\n", name);
        }
    }
    wait(0.1);
}



int main(){
    
    
    
    while(1)
    {
        tmpSensor.read();
        averageTH(tmpSensor.getFahrenheit(), tmpSensor.getHumidity());
        waitforbuttons();
    }
 }