#include "mbed.h"
#include "USBKeyboard.h"
#include "PinDetect.h"

AnalogIn   potx(A0);
AnalogIn   poty(A1);
USBKeyboard keyboard;
PinDetect button(D3);
PinDetect button1(D4);
PinDetect button2(D5);
int state[3];

void button_pressed() {
    state[0] = 1;
}

void button_released() {
    state[0] = 0;
}

void button1_pressed() {
    state[1] = 1;
}

void button1_released() {
    state[1] = 0;
}

void button2_pressed() {
    state[2] = 1;
}

void button2_released() {
    state[2] = 0;
}

int main() {
    button.attach_asserted(&button_pressed);
    button.attach_deasserted(&button_released);
    button.setAssertValue(0);
    button.setSampleFrequency();

    button1.attach_asserted(&button1_pressed);
    button1.attach_deasserted(&button1_released);
    button1.setAssertValue(0);
    button1.setSampleFrequency();

    button2.attach_asserted(&button2_pressed);
    button2.attach_deasserted(&button2_released);
    button2.setAssertValue(0);
    button2.setSampleFrequency();

    while(1) {
        if (state[0] == 1) {
            keyboard.keyCode('e');
        } 
        if (state[1] == 1) {
            keyboard.keyCode('m');
        } 
        if (state[2] == 1) {
            keyboard.keyCode('n');
        } 
        int potx_read = (int)(potx.read() * 100.0f);
        int poty_read = (int)(poty.read() * 100.0f);
        if (potx_read > 70) {
            keyboard.keyCode('s');
        }else if (potx_read < 30) {
            keyboard.keyCode('w');
        } else if (poty_read > 80) {
            keyboard.keyCode('d');
        } else if (poty_read < 20) {
            keyboard.keyCode('a');
        }
        wait_ms(1); 
    }
}
