#include "mbed.h"
#include "USBMouseKeyboard.h"
#include "LSM303DLHC.h"
#include "PinDetect.h"
#include "math.h"

// define I2C Pins and address for KL25Z. Taken from default sample code.
PinName const SDA = D14;
PinName const SCL = D15;
DigitalIn p1(D3);
DigitalIn p2(D4);
DigitalIn p3(D5);
//PinDetect p1(D3);
//PinDetect p2(D4);
//PinDetect p3(D5);
AnalogIn fsr(A5);
#define MMA8451_I2C_ADDRESS (0x1d<<1)

//serial connection to PC via USB
Serial pc(USBTX, USBRX);
LSM303DLHC lsm(SDA, SCL);
USBMouseKeyboard mouseKey;


float fsrVal;
float fsrValPrev;
int count;
// acc and mag values
float ax, ay, az, mx, my, mz;
float theta;
int mousePress;
float flt_force_prev;
int oldx, oldy;

int mouseTravelX = 0;
int mouseTravelY = 0;

float angles[8] = {0};
float forces[8] = {0};

void mouseMem(int x_, int y_) {
    mouseTravelX += x_;
    mouseTravelY += y_;
}

float filter(float* array, int len, float value) {
    float mean = 0.0;
    for(int i = 0; i<len - 1; i++) {
        mean += array[i + 1];
        array[i] = array[i + 1];
    }
    mean += value;
    array[len - 1] = value;
    return mean / (float)len;
}




int main(void){
    int x = 0;
    int y = 0;
    int mouseClickDown = 0;
    bool aim = false;
    while(1){
        fsrVal = fsr.read();
        lsm.read(&ax, &ay, &az, &mx, &my, &mz);
        
        float cur_angle = atan(ax / az);
        float cur_force = fsrVal*1000;
        
        float flt_force = filter(forces, 8, cur_force);
        float flt_angle = filter(angles, 8, cur_angle);
        
        //mouseKey.printf("ax: %1.2f az: %1.2f fsrVal: %1.2f \n", ax, az, fsrVal);        
        
        //mouseKey.printf("fsrVal: %1.2f fsrValPrev: %1.2f flt_force: %1.2f\n",
        //                fsrVal, fsrValPrev, flt_force);
        if(p1 == 0){
           mouseKey.keyCode('a'); 
           
        }
        if (p2 == 0) {
            mouseKey.click(MOUSE_LEFT);
            wait(0.05);
        }
        

        //if ((flt_force > 0.2)) {
            
        //mouseKey.printf("fsrVal %1.2f fsrValPrev %1.2f flt_force %1.2f \n", fsrVal, fsrValPrev,flt_force);
        if(p3 == 0){
            if (mouseClickDown == 0) {
            mouseKey.press(MOUSE_LEFT);
            mouseClickDown = 1;
            }
            //wait(0.02);
        }
            else {
                if (mouseClickDown == 1) {
                mouseKey.release(MOUSE_LEFT);
                mouseClickDown = 0;
                } 
        }
        if ((((flt_force_prev - flt_force) > 7) || flt_force == 0) && aim) {
            //mouseKey.keyCode('c');
            aim = false;
        } else if ((flt_force >20)&&(!aim)) {
            //mouseKey.keyCode('b');
            aim = true;
            //mouseKey.press(MOUSE_LEFT);
        }
            
            if (ax > 0 && az > 0) {
                x = (int) (0.0 - cos(flt_angle) * flt_force);
                y = (int) (sin(flt_angle) * flt_force);
            } else if (ax < 0 && az > 0) {
                x = (int) (0.0 - cos(flt_angle) * flt_force);
                y = (int) (sin(flt_angle) * flt_force);                
            }
            
            //mouseKey.printf("Angle: %1.2f Force: %1.2f Move: x: %0d y: %0d x_: %0d y_ = %0d\n", 
            //                flt_angle, flt_force, x, y, mouseTravelX, mouseTravelY);
                            
            mouseKey.move((x-oldx), (y-oldy));
            mouseMem((x-oldx),(y-oldy));
            oldx = x;
            oldy = y;
            fsrValPrev = fsrVal;
            flt_force_prev = flt_force;
        wait(0.01);
    }
}

