// Bryan Thov and Yinglong Li
// HW 3 - Game Controller
// IDD Fall '15

#include "mbed.h"
#include "MMA8451Q.h"

// Signals Sent
// s = Button Press = shoot
// j = Arm Raised = jump
// d = Arm Down = dash
// l = Arm turn left = left
// r = Arm turn right = right
// x = Null -> Not Active

// I2C
PinName const SDA = PTE25;
PinName const SCL = PTE24;
#define MMA8451_I2C_ADDRESS (0x1d<<1)

// LED
DigitalOut myled(LED_GREEN);
DigitalOut myled1(LED_RED);
DigitalOut myled2(LED_BLUE);

// Serial
Serial pc(USBTX, USBRX);

// Game Inputs
DigitalIn button(D9);

// Initialize Instruction String
// _ _ _ _ _ \0 = j d l r s \0
// If the instruction is not there, will be x, which is "Null"
// \0 = Terminiating String
char instr[7] = {'x', 'x', 'x', 'x', 'x' ,'a', '\0'};

int main() {
    // Set up accelerometer
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS); 
    float x, y, z;
    
    // Turn off LEDs
    myled = !myled;
    myled1 = !myled1;
    myled2 = !myled2;

    while(1) {
        // Get accelerometer values
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        wait(0.05f);
        //pc.printf("%1.2f %1.2f %1.2f\r\n", x, y, z);
        
        // Neglect calculating roll/pitch and use raw analog data = saves time 
        // As x approaches 0 and y is positive, the controller is going up (jumping)
        // As x approaches 0 and y is negative, the controller is going down (dashing)
        // Threshold_Min = -0.7 (Tested -> We will finalize)  
        // For y: Threshold_Max and Threshold_Min = +- 0.75 to +- 1.1

        wait_ms(100);
        if (x > -0.7 & y > 0.75 & y < 1.1 & z > -0.2 & z < 0.2) {
            instr[0] = 'j';
        } else {
            instr[0] = 'x';
        } 
            
        if (x > -0.7 & y < -0.75 & y > -1.1 & z > -0.2 & z < 0.2) {
            instr[1] = 'd';
        } else {
            instr[1] = 'x';
        }
        
        // For Directional Movement
        // Rest is when z = 0
        // As z approaches -1, the controller is going right
        // As z approaches 1, the controller is going left
        // Threshold_Max and Threshold_Min = +- 0.4

        if (z > 0.4) {
            instr[2] = 'l';
        } else {
            instr[2] = 'x';
        }
                
        if (z < -0.4) {
            instr[3] = 'r';
        } else {
            instr[3] = 'x';
        }

        // Jump + R/L
        if (x > -0.7 & z < -0.4 & y > 0) {
            instr[0] = 'j';
            instr[3] = 'r';
        } else if (x > -0.7 & z > 0.4 & y > 0) {
            instr[0] = 'j';
            instr[2] = 'l';
        } 
        
        // Dash + R/L
        if (x > -0.7 & z < -0.4 & y < 0) {
            instr[0] = 'd';
            instr[3] = 'l';
        } else if (x > -0.7 & z > 0.4 & y < 0) {
            instr[0] = 'd';
            instr[2] = 'r';
        } 
        
        // See if button is pressed
        if(button == 0) {
            instr[4] = 's';
        } else {
            instr[4] = 'x';
        }

        // Print out instruction string and reset rest
        pc.printf(instr);
        wait_ms(50);
    }
}

