#include "mbed.h"
#include "PinDetect.h"

Serial pc(USBTX,USBRX);

char alphabet[] = {'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','\0'};
int indices[] = {128,64,32,8,4,2,136,132,130,129,72,68,66,65,40,36,34,33,24,20,18,17,96,6,12,3};

DigitalOut highPin(D15); // Pin Used to bring left side buttons high may not be needed
bool boolArray[8];

// Left side pins
PinDetect L1(PTD3);
PinDetect L2(PTD2);
PinDetect L3(PTD0);
PinDetect L4(PTC8);

// Right side pins
PinDetect R1(PTA16);
PinDetect R2(PTC17);
PinDetect R3(PTC16);
PinDetect R4(PTC11);

// Left Button ISRs
void L1ButtonHeld(void){
    boolArray[0] = 0;
    }
void L1ButtonRelease(void){
    boolArray[0] = 1;
    }   
void L2ButtonHeld(void){
    boolArray[1] = 0;
    }
void L2ButtonRelease(void){
    boolArray[1] = 1;
    }       
void L3ButtonHeld(void){
    boolArray[2] = 0;
    }
void L3ButtonRelease(void){
    boolArray[2] = 1;
    }   
void L4ButtonHeld(void){
    boolArray[3] = 0;
    }
void L4ButtonRelease(void){
    boolArray[3] = 1;
    }   

// Right Side ISRs
void R1ButtonHeld(void){
    boolArray[4] = 0;
    }
void R1ButtonRelease(void){
     boolArray[4] = 1;
    }   
void R2ButtonHeld(void){
    boolArray[5] = 0;
    }
void R2ButtonRelease(void){
    boolArray[5] = 1;
    }   
void R3ButtonHeld(void){
    boolArray[6] = 0;
    }
void R3ButtonRelease(void){
    boolArray[6] = 1;
    }   
void R4ButtonHeld(void){
    boolArray[7] = 0;
    }
void R4ButtonRelease(void){
    boolArray[7] = 1;
    }   

int main() {
    pc.printf("Starting\n\r");
    highPin = 1;

    L1.attach_asserted(&L1ButtonHeld);
    L1.attach_deasserted(&L1ButtonRelease);
    L1.setSampleFrequency();
    L1.mode(PullUp);

    L2.attach_asserted(&L2ButtonHeld);
    L2.attach_deasserted(&L2ButtonRelease);
    L2.setSampleFrequency();
    L2.mode(PullUp);
    
    L3.attach_asserted(&L3ButtonHeld);
    L3.attach_deasserted(&L3ButtonRelease);
    L3.setSampleFrequency();
    L3.mode(PullUp);

    L4.attach_asserted(&L4ButtonHeld);
    L4.attach_deasserted(&L4ButtonRelease);
    L4.setSampleFrequency();
    L4.mode(PullUp);

    R1.attach_asserted(&R1ButtonHeld);
    R1.attach_deasserted(&R1ButtonRelease);
    R1.setSampleFrequency();
    R1.mode(PullUp);

    R2.attach_asserted(&R2ButtonHeld);
    R2.attach_deasserted(&R2ButtonRelease);
    R2.setSampleFrequency();
    R2.mode(PullUp);

    R3.attach_asserted(&R3ButtonHeld);
    R3.attach_deasserted(&R3ButtonRelease);
    R3.setSampleFrequency();
    R3.mode(PullUp);

    R4.attach_asserted(&R4ButtonHeld);
    R4.attach_deasserted(&R4ButtonRelease);
    R4.setSampleFrequency();
    R4.mode(PullUp);
   
    while(1) {
        int num = 0;
        int pow = 1;
        
        for (int i = 7; i>-1; i--){
            num = num + boolArray[i] * pow;
            pow = pow * 2;
        }
        
        for (int i = 0; i < 27; i++){
            if (num == indices[i]){
                pc.printf("%c",alphabet[i]);
            }
        }
            if  (num == 16){
                pc.printf("\b \b");
            }
            
            if (num == 1){
                pc.printf(" ");
            }
        
        wait(0.2);
}
