#include "mbed.h"
#include "DebounceIn.h"
#include "MMA8451Q.h"
#include "USBKeyboard.h"

USBKeyboard keyboard;
char leftTable[] = {'Q', 'A', 'D', 'G', 'J', 'M', 'P', 'T', 'W', '\b'};
char centerTable[] = {'Z', 'B', 'E', 'H', 'K', 'N', 'R', 'U', 'X', ' '};
char rightTable[] = {'Q', 'C', 'F', 'I', 'L', 'O', 'S', 'V', 'Y', '\b'};

DebounceIn buttons[] = {
    DebounceIn(D2),
    DebounceIn(D3),
    DebounceIn(D4),
    DebounceIn(D5),
    DebounceIn(D6),
    DebounceIn(D7),
    DebounceIn(D8),
    DebounceIn(D9),
    DebounceIn(D10),
    DebounceIn(D11)
};
DigitalOut red(LED_RED);
DigitalOut blue(LED_BLUE);
DigitalOut green(LED_GREEN);

MMA8451Q acc(PTE25, PTE24, (0x1d << 1));

int main() {
    red = 1;
    blue = 1;
    green = 1;
    for (int i = 0; i < 10; i++) {
        buttons[i].mode(PullUp);
    }

    while(1) {
        for (int i = 0; i < 10; i++) {
            if (buttons[i]) {
                int yAccel = acc.getAccY();
                if (yAccel < -2000) {
                    red = 0;
                    keyboard.keyCode(leftTable[i]);
                } else if (yAccel > 2000) {
                    green = 0;
                    keyboard.keyCode(rightTable[i]);
                } else {
                    blue = 0;
                    keyboard.keyCode(centerTable[i]);
                }
            }
        }
        wait(0.2);
        red = 1;
        blue = 1;
        green = 1;   
    }
}