#include "mbed.h"
#include "PinDetect.h"
#include "USBKeyboard.h"
#include <string>
#include <ctype.h>

USBKeyboard key;

Serial pc(USBTX, USBRX);

PinDetect b1( D13 , PullUp);
PinDetect b2( D12 , PullUp);
PinDetect b3( D11 , PullUp);
PinDetect b4( D10 , PullUp);
PinDetect b5( D9 , PullUp);
PinDetect b6( D8 , PullUp);
PinDetect b7( D7 , PullUp);
PinDetect b8( D6 , PullUp);
PinDetect b9( D5 , PullUp);

PinDetect shift( D4 , PullUp);

DigitalOut green(LED_GREEN);
DigitalOut red(LED_RED);
DigitalOut blue(LED_BLUE);

int pressed[2];         // 1   2   3   4   5   6   7   8   9
const char* button1[9] = {"a", "", "","v", "", "", "", "", ""};
const char* button2[9] = { "","n", "", "","l", "", "", "", ""};
const char* button3[9] = { "", "","i", "", "","x", "", "", ""};
const char* button4[9] = {"q", "", "","h","k", "","g", "", ""};
const char* button5[9] = { "","u", "","c","o","b", "","d", ""};
const char* button6[9] = { "", "","p", "","m","r", "", "","j"};
const char* button7[9] = { "", "", "","y", "", "","t", "", ""};
const char* button8[9] = { "", "", "", "","w", "","\b","e"," "};
const char* button9[9] = { "", "", "", "", "","f", "","z","s"};

bool upper = false;

#define OFF 1
#define ON 0


void initializePressed() {
    pressed[0] = 0;
    pressed[1] = 0;
}

void deliverButton() {
    const char* x;
    switch (pressed[0]) {
    case 1:
        x = button1[pressed[1]-1];
        break;
    case 2:
        x = button2[pressed[1]-1];
        break;
    case 3:
        x = button3[pressed[1]-1];
        break;
    case 4:
        x = button4[pressed[1]-1];
        break;
    case 5:
        x = button5[pressed[1]-1];
        break;
    case 6:
        x = button6[pressed[1]-1];
        break;
    case 7:
        x = button7[pressed[1]-1];
        break;
    case 8:
        x = button8[pressed[1]-1];
        break;
    case 9:
        x = button9[pressed[1]-1];
        break;
    default:
        printf("pressed[0] was not 1\n");
        return;
    }
    if (upper) {
        pc.putc(toupper(x[0]));
        key.putc(toupper(x[0]));
    } else {
        pc.putc(x[0]);
        key.putc(x[0]);
        
    }
}

void fillButton(int button) {
    if (pressed[0] != 0 && pressed[1] == 0) {
        pressed[1] = button;
    } else if (pressed[0] == 0) {
        pressed[0] = button;
    } else {
        printf("WHAT\n");
    }
}

void b1Pressed(void) { fillButton(1); }
void b2Pressed(void) { fillButton(2); }
void b3Pressed(void) { fillButton(3); }
void b4Pressed(void) { fillButton(4); }
void b5Pressed(void) { fillButton(5); }
void b6Pressed(void) { fillButton(6); }
void b7Pressed(void) { fillButton(7); }
void b8Pressed(void) { fillButton(8); }
void b9Pressed(void) { fillButton(9); }

void shiftOn(void) { green = ON; upper = true; }
void shiftOff(void) { green = OFF; upper = false; }

int main() {
    // turn off LED
    green = OFF;
    red = OFF;
    blue = OFF;

    initializePressed();

    b1.attach_asserted(&b1Pressed);
    b1.setAssertValue(0);
    b1.setSampleFrequency();

    b2.attach_asserted(&b2Pressed);
    b2.setAssertValue(0);
    b2.setSampleFrequency();

    b3.attach_asserted(&b3Pressed);
    b3.setAssertValue(0);
    b3.setSampleFrequency();

    b4.attach_asserted(&b4Pressed);
    b4.setAssertValue(0);
    b4.setSampleFrequency();

    b5.attach_asserted(&b5Pressed);
    b5.setAssertValue(0);
    b5.setSampleFrequency();

    b6.attach_asserted(&b6Pressed);
    b6.setAssertValue(0);
    b6.setSampleFrequency();

    b7.attach_asserted(&b7Pressed);
    b7.setAssertValue(0);
    b7.setSampleFrequency();

    b8.attach_asserted(&b8Pressed);
    b8.setAssertValue(0);
    b8.setSampleFrequency();

    b9.attach_asserted(&b9Pressed);
    b9.setAssertValue(0);
    b9.setSampleFrequency();

    shift.attach_asserted(&shiftOn);
    shift.attach_deasserted(&shiftOff);
    shift.setSampleFrequency();

    while(1) {
        if (pressed[0] != 0 && pressed[1] != 0) {
            deliverButton();
            initializePressed();
        }
    }
}
