#include "mbed.h"
#include "PinDetect.h"
// Initialize a pins to perform analog input and digital output fucntions
AnalogIn   ain(A0);
DigitalOut dout(D3);
PinDetect  pin(D2);
char letter;
char *lower_arr = " zyxwvutsrqponmlkjihgfedcba";
char *upper_arr = " ZYXWVUTSRQPONMLKJIHGFEDCBA";
char *arr = lower_arr;
void enter(void)
{
    printf("%c", letter);
}

void capslock_on(void) {
    dout = !dout;
}

int main(void)
{    
    dout = 0;
    pin.setSampleFrequency();
    pin.attach_asserted(&enter);
    pin.attach_deasserted_held(&capslock_on);
    printf("\r\n Input here: \r\n ");    
    while (1) {
        if (dout){
            arr = upper_arr;
        } else {
            arr = lower_arr;
        }
        int input = (int)(ain.read()* 100.0f / 3.705f);
        letter = arr[input];
        printf("%c", letter);
        printf("\b");
    }
}