#include "mbed.h"
#include "PinDetect.h"

PinDetect key1(D2, PullUp);
PinDetect key2(D3, PullUp);
PinDetect key3(D4, PullUp);
PinDetect key4(D5, PullUp);
PinDetect key5(D6, PullUp);
PinDetect key6(D7, PullUp);
PinDetect key7(D8, PullUp);
DigitalOut myled(LED1);

Serial pc(USBTX, USBRX);

int fingers[6] = {0,0,0,0,0,0};
int enter;

int notes[6] = {2,3,4,5,6,7};

void key1PressedHeld( void ) {
    enter = 1;
}

void key1Released( void ) {
    enter = 0;
}

void key2PressedHeld( void ) {
    fingers[0] = 1;
}

void key2Released( void ) {
    fingers[0] = 0;
}

void key3PressedHeld( void ) {
    fingers[1] = 1;
}

void key3Released( void ) {
    fingers[1] = 0;
}

void key4PressedHeld( void ) {
    fingers[2] = 1;
}

void key4Released( void ) {
    fingers[2] = 0;
}

void key5PressedHeld( void ) {
    fingers[3] = 1;
}

void key5Released( void ) {
    fingers[3] = 0;
}

void key6PressedHeld( void ) {
    fingers[4] = 1;
}

void key6Released( void ) {
    fingers[4] = 0;
}

void key7PressedHeld( void ) {
    fingers[5] = 1;
}

void key7Released( void ) {
    fingers[5] = 0;
}
int note;

int noteassign(int fingers) {
    if (fingers == {1,1,1,1,1,1})
        note = 2;
    else if (fingers == {0,1,1,1,1,1})
        note = 3;
    else if (fingers == {0,0,1,1,1,1})
        note = 4;
    else if (fingers == {0,0,0,1,1,1})
        note = 5;
    else if (fingers == {0,0,0,0,1,1})
        note = 6;
    else if (fingers == {0,0,0,0,0,1})
        note = 7;
    return note
}

int notesplayed[2] = {0,0};

int notescurr(int note) {
    notesplayed[0] = notesplayed[1];
    notesplayed[1] = note;
}

void key1PressedHeld(int notesplayed)
{
    if (notescurr == {2,0})
        pc.printf("E");
    else if (notescurr == {3,0})
        pc.printf("T");
    else if (notescurr == {4,0})
        pc.printf("A");
    else if (notescurr == {5,0})
        pc.printf("O");
    else if (notescurr == {6,0})
        pc.printf("I");
    else if (notescurr == {7,0})
        pc.printf("N");
    else if (notescurr == {2,3})
        pc.printf("S");
    else if (notescurr == {2,4})
        pc.printf("H");
    else if (notescurr == {2,5})
        pc.printf("R");
    else if (notescurr == {2,6})
        pc.printf("D");
    else if (notescurr == {2,7})
        pc.printf("L");
    else if (notescurr == {3,2})
        pc.printf("C");
    else if (notescurr == {3,4})
        pc.printf("U");
    else if (notescurr == {3,5})
        pc.printf("M");
    else if (notescurr == {3,6})
        pc.printf("W");
    else if (notescurr == {3,7})
        pc.printf("F");
    else if (notescurr == {4,2})
        pc.printf("G");
    else if (notescurr == {4,3})
        pc.printf("Y");
    else if (notescurr == {4,5})
        pc.printf("P");
    else if (notescurr == {4,6})
        pc.printf("B");
    else if (notescurr == {4,7})
        pc.printf("V");
    else if (notescurr == {5,2})
        pc.printf("K");
    else if (notescurr == {5,3})
        pc.printf("J");
    else if (notescurr == {5,4})
        pc.printf("X");
    else if (notescurr == {5,6})
        pc.printf("Q");
    else if (notescurr == {5,7})
        pc.printf("Z");
    else if (notescurr == {0,0})
        pc.printf(" ");
};

void key1Released(void) {
    notesplayed[0] = 0;
    notesplayed[1] = 0;
}

int main() {
    key1.attach_asserted_held( &key1PressedHeld );
    key2.attach_asserted_held( &key2PressedHeld );
    key3.attach_asserted_held( &key3PressedHeld );
    key4.attach_asserted_held( &key4PressedHeld );
    key5.attach_asserted_held( &key5PressedHeld );
    key6.attach_asserted_held( &key6PressedHeld );
    key7.attach_asserted_held( &key7PressedHeld );
    key1.attach_deasserted( &key1Released );
    key2.attach_deasserted( &key2Released );
    key3.attach_deasserted( &key3Released );
    key4.attach_deasserted( &key4Released );
    key5.attach_deasserted( &key5Released );
    key6.attach_deasserted( &key6Released );
    key7.attach_deasserted( &key7Released );

}
