#include "mbed.h"
#include "USBKeyboard.h" 
#include "PinDetect.h"  

PinDetect key1(D1), key2(D2), key3(D3), key4(D4), key5(D5), key6(D6), key7(D7), key8(D8), key9(D9), key10(D10), key11(D11), key12(D12), key13(D13);
//IMPORTANT Keys 1, 7, and 13 were not used in the code below to keep my total switches used to 10. However, those pins can be added so that the entire alphabet can be properly signed. 
//Without them there are a couple letters that are signed differently than the actual way. 

int key1Stat;
int key2Stat;
int key3Stat;
int key4Stat;
int key5Stat;
int key6Stat;
int key7Stat;
int key8Stat;
int key9Stat;
int key10Stat;
int key11Stat;
int key12Stat;
int key13Stat;
int totalKeys1;
int totalKeys;
int value;
int i;
char letter;
int keyNumbers[]={39036, 4126, 32798, 2047, 34814, 32767, 2174, 63, 8191, 10365, 255, 2205, 4222, 6142, 16383, 511, 158, 127, 10396, 34972, 732, 221, 31, 2716, 34941, 68219, 4095, 542, 2078};
char keyLetters [] ={'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '\b', '\n'};
                
//keyNumbers is an array of unique values that correspond to a combinations of buttos pressed to form a letter that matches in its position in the array to a letter in keyLetters

USBKeyboard key;

void key1on(void){ // These functions give a particular value to a key when pressed
    key1Stat = 5;
    }
void key2on(void){
    key2Stat = 31;
    }
void key3on(void){
    key3Stat = 63;
    }
void key4on(void){
    key4Stat= 127;
    }
void key5on(void){
    key5Stat = 255;
    }
void key6on(void){
    key6Stat = 511;
    }
void key7on(void){
    key7Stat = 1023;
    }
void key8on(void){
    key8Stat = 2047;
    }
void key9on(void){
    key9Stat = 4095;
    }
void key10on(void){
    key10Stat = 8191;
    }
void key11on(void){
    key11Stat = 16383;
    }
void key12on(void){
    key12Stat = 32767;
    }
void key13on(void){
    key13Stat = 65535;
    }

int main() {
    
    key1.mode(PullUp); //set the pins to pullup mode
    key2.mode(PullUp);
    key3.mode(PullUp);
    key4.mode(PullUp);
    key5.mode(PullUp);
    key6.mode(PullUp);
    key7.mode(PullUp);
    key8.mode(PullUp);
    key9.mode(PullUp);
    key10.mode(PullUp);
    key11.mode(PullUp);
    key12.mode(PullUp);
    key13.mode(PullUp);
    
    key1.setSampleFrequency(); //Set the sampling frequency for each pin
    key2.setSampleFrequency();
    key3.setSampleFrequency();
    key4.setSampleFrequency();
    key5.setSampleFrequency();
    key6.setSampleFrequency();
    key7.setSampleFrequency();
    key8.setSampleFrequency();
    key9.setSampleFrequency();
    key10.setSampleFrequency();
    key11.setSampleFrequency();
    key12.setSampleFrequency();
    key13.setSampleFrequency();
    
    key1.attach_asserted(&key1on); //in pull up mode this checks to see if a button is pressed
    key2.attach_asserted(&key2on);
    key3.attach_asserted(&key3on);
    key4.attach_asserted(&key4on);
    key5.attach_asserted(&key5on);
    key6.attach_asserted(&key6on);
    key7.attach_asserted(&key7on);
    key8.attach_asserted(&key8on);
    key9.attach_asserted(&key9on);
    key10.attach_asserted(&key10on);
    key11.attach_asserted(&key11on);
    key12.attach_asserted(&key12on);
    key13.attach_asserted(&key13on);
    
    while(1) {
        i=0;
        value=0;
        totalKeys1= key1Stat + key2Stat + key3Stat + key4Stat + key5Stat + key6Stat + key7Stat + key8Stat + key9Stat + key10Stat + key11Stat + key12Stat + key13Stat; //Sum the values of the buttons that are pressed
        wait(0.3);
        totalKeys= key1Stat + key2Stat + key3Stat + key4Stat + key5Stat + key6Stat + key7Stat + key8Stat + key9Stat + key10Stat + key11Stat + key12Stat + key13Stat; // Sum again after some time for debouncing 

      if (totalKeys > 0 && totalKeys1==totalKeys) { 
        while (totalKeys != value && i < sizeof(keyNumbers)){
            value = keyNumbers[i+1]; //see if the sum matches one of the values in the array of numbers that correspond to a letter
            i++;
        
            }
        
        key.printf("%c",keyLetters[i]); //print the letter that corresponds to the value in the keyNumbers Array
        key1Stat=0; //make sure to set all the states of the keys back to zero
        key2Stat=0;
        key3Stat=0;
        key4Stat=0;
        key5Stat=0;
        key6Stat=0;
        key7Stat=0;
        key8Stat=0;
        key9Stat=0;
        key10Stat=0;
        key11Stat=0;
        key12Stat=0;
        key13Stat=0;
        
             }                                                                                                                                                                                          
             }
    }