#include "mbed.h"
#include "PinDetect.h"
#include "USBKeyboard.h"

//Serial pc(USBTX, USBRX);

AnalogIn x_in(A0);
AnalogIn y_in(A1);
AnalogIn z_in(A2);

USBKeyboard keyboard;
PinDetect start_button(D13);
PinDetect up_button(D8);
PinDetect down_button(D9);
PinDetect right_button(D10);
PinDetect left_button(D12);
PinDetect select_button(D11);

int main() {
    start_button.mode(PullUp);
    up_button.mode(PullUp);
    down_button.mode(PullUp);
    right_button.mode(PullUp);
    left_button.mode(PullUp);
    
    while(1) {
//        pc.printf("x is: %f\n\r", x_in.read());
//        pc.printf("y is: %f\n\r", y_in.read());
//        pc.printf("z is: %f\n\r", z_in.read());
        
//        wait(.5);
        
        if (x_in.read() > .65 || x_in.read() < .35 || y_in.read() > .65 || y_in.read() < .35 || z_in.read() > .65 || z_in.read() < .35) {
            keyboard.printf("%s", "a");
        } else if (start_button == 0) {
            keyboard.keyCode(32);
        } else if (up_button == 0) {
            keyboard.keyCode(UP_ARROW);
        } else if (down_button == 0) {
            keyboard.keyCode(DOWN_ARROW);
        } else if (right_button == 0) {
            keyboard.keyCode(RIGHT_ARROW);
        } else if (left_button == 0) {
            keyboard.keyCode(LEFT_ARROW);
        } else if (select_button ==0) {
            keyboard.printf("%s", "a");
        }
    }
}
