#include "mbed.h"
#include "USBKeyboard.h"
// #include "DigitalIn.h"

#define NUM_WAIT 80
#define DELAY 2

BusOut leds( LED1, LED2, LED3, LED4 );
BusIn pins(D3,D4,D5,D6,D7,D8,D9,D10,D11,D12);

//USBKeyboard
USBKeyboard keyboard;

int main(void) {
    leds = 255;
    int old_pins = 0;
    char count = 0;
    while (1) {
        if (old_pins == pins.read()) {
//            keyboard.printf("Count: %d\r\n", count);
            count++;
        } else {
            count = 0;
        }
        old_pins = pins.read();
        if (count >= NUM_WAIT) {
//            keyboard.printf("%d\r\n", ~(pins.read()));
            old_pins = 0x3ff & (~old_pins); // make sure all other bits are 0 (after the 10 lowest order)
            switch(old_pins) {
                case 0x000: break;
                // Vowels on left hand - one per finger
                case 0x001: keyboard.printf("a");break;
                case 0x002: keyboard.printf("e");break;
                case 0x004: keyboard.printf("i");break;
                case 0x008: keyboard.printf("o");break;
                case 0x010: keyboard.printf("u");break;
                
                // Consonants on right hand, different combos
                case 0x020: keyboard.printf("t");break;
                case 0x040: keyboard.printf("n");break;
                case 0x080: keyboard.printf("s");break;
                case 0x100: keyboard.printf("h");break;
                case 0x200: keyboard.printf("r");break;
                case 0x060: keyboard.printf("d");break;
                case 0x0A0: keyboard.printf("l");break;
                case 0x120: keyboard.printf("c");break;
                case 0x220: keyboard.printf("m");break;
                case 0x0C0: keyboard.printf("w");break;
                case 0x140: keyboard.printf("f");break;
                case 0x240: keyboard.printf("g");break;
                case 0x180: keyboard.printf("y");break;
                case 0x280: keyboard.printf("p");break;
                case 0x300: keyboard.printf("b");break;
                case 0x0E0: keyboard.printf("v");break;
                case 0x160: keyboard.printf("k");break;
                case 0x260: keyboard.printf("j");break;
                case 0x1a0: keyboard.printf("x");break;
                case 0x2a0: keyboard.printf("q");break;
                case 0x320: keyboard.printf("z");break;
                
                // Special Keys
                case 0x003: keyboard.printf("\r\n");break;
                case 0x005: keyboard.printf(" ");break;
                case 0x009: keyboard.keyCode(KEY_CAPS_LOCK);break;
                case 0x011: keyboard.printf("\b");break;
                
                default:
                    break;
            }
        }
        wait_ms(DELAY);
    }
}