#include "mbed.h"
#include "PinDetect.h"

PinDetect pin1(D2, PullUp);
PinDetect pin2(D3, PullUp);
PinDetect pin3(D4, PullUp);
DigitalOut myled(LED1);

Serial pc(USBTX, USBRX);

int pinbus[5] = {0, 0, 0, 0, 0};

char letters[1][27] = {
{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' '},
};
                                                   
int pinbusvalues[27][4] = {
{0, 1, 2, 2}, {1, 0, 0, 0}, {1, 0, 1, 0}, {2, 0, 0, 2}, {0, 2, 2, 2},
{0, 0, 1, 0}, { 1, 1, 0, 2}, {0, 0, 0, 0}, { 0, 0, 2, 2}, {0, 1, 1, 1}, 
{ 1, 0, 1, 2}, { 2, 2, 2, 2}, { 1, 1, 2, 2}, {1, 0, 2, 2}, {2, 0, 0, 0},
{0, 1, 1, 0}, { 1, 1, 0, 1}, {0, 2, 0, 2}, {0, 0, 0, 2}, {1, 2, 2, 2},
{0, 0, 1, 2}, {0, 0, 0, 1}, {0, 2, 2, 0}, {1, 0, 0, 1}, {1, 0, 1, 1},
{1, 1, 0, 0}, {0, 0, 0, 2}
};

int j=0;
void b1(void){
//   pc.printf("From F1: %d", j);
      pinbus[j] = 0;
    j=j+1;
}
void b2(void){
// pc.printf("From F2: %d", j);
    pinbus[j] = 1;
    j=j+1;
}
void b3(void){
//     pc.printf("From F3: %d", j);
    pinbus[j] = 2;
    j=j+1;
}

void keyPressed(void){
//     pc.printf("From keypressed: %d", j);
    if (j < 4)
      return;
//      pc.printf("%d %d %d %d", pinbus[0], pinbus[1], pinbus[2], pinbus[3]);
    for (int i=0; i<27; i++) {
        if (pinbus[0] == pinbusvalues[i][0]&&pinbus[1] == pinbusvalues[i][1]&&pinbus[2] == pinbusvalues[i][2]&&pinbus[3] == pinbusvalues[i][3]) {
            pc.printf("%c", letters[0][i]);
        }
     }
    j=0;
}

int main() {
    pc.baud(9600);
    
    pin1.attach_deasserted(&b1);
    pin2.attach_deasserted(&b2);
    pin3.attach_deasserted(&b3);
    

    pin1.attach_asserted(&keyPressed);
    pin2.attach_asserted(&keyPressed);
    pin3.attach_asserted(&keyPressed);
            //set frequency
    pin1.setSampleFrequency();
    pin2.setSampleFrequency();
    pin3.setSampleFrequency();
        
    while(1){
        myled = !myled;
        wait(0.2);
    }            
}