#include "mbed.h"

/********************
 * Interactive Device Design Custom Class Demonstration
 * bjoern@eecs.berkeley.edu, 9/23/2015
 ********************/


class RGBLed {
public:
    
    // constructor - same name as class, does nothing
    RGBLed () {
    }
    
    //set red, green, blue of on-board LED
    // r,g,b range from 0.0(off) to 1.0(full on)
    void setColor(float r, float g, float b){
        PwmOut redPin(LED_RED);
        PwmOut greenPin(LED_GREEN);
        PwmOut bluePin(LED_BLUE);
        redPin = 1.0-r; //invert: PWM 0=on, 1.0=off
        bluePin = 1.0-b;
        greenPin = 1.0-g;
    }
private:
    //no private methods or fields
};

    
RGBLed myLed; //declare a variable of our new class type

int main() {
    while(1) {
        myLed.setColor(1.0, 0.0, 0.0); //call the member function setColor() - this is red
        wait(0.2);
        myLed.setColor(0.0, 1.0, 0.0); //this is green
        wait(0.2);
    }
}
