#include "mbed.h"
#include "PinDetect.h"

/*CS294 HW2 - Text Entry code. */

Serial pc(USBTX, USBRX);

PinDetect button1(D2);
PinDetect button2(D3);
PinDetect button3(D4);
PinDetect button4(D5);
PinDetect button5(D6);
PinDetect button6(D7);
PinDetect button7(D8);
PinDetect button8(D9);
PinDetect button9(D10);
/*Reserved for Space bar*/
PinDetect button10(D11);

int state[10];

int alphabet_map[] = {'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y','Z',' '};

void button1_pressed() {
    state[0] = 1;
}
void button2_pressed() {
    state[1] = 1;
}
void button3_pressed() {
    state[2] = 1;
}
void button4_pressed() {
    state[3] = 1;
}
void button5_pressed() {
    state[4] = 1;
}
void button6_pressed() {
    state[5] = 1;
}
void button7_pressed() {
    state[6] = 1;
}
void button8_pressed() {
    state[7] = 1;
}
void button9_pressed() {
    state[8] = 1;
}
void button10_pressed() {
    state[9] = 1;
}

void button1_released() {
    state[0] = 0;
}
void button2_released() {
    state[1] = 0;
}
void button3_released() {
    state[2] = 0;
}
void button4_released() {
    state[3] = 0;
}
void button5_released() {
    state[4] = 0;
}
void button6_released() {
    state[5] = 0;
}
void button7_released() {
    state[6] = 0;
}
void button8_released() {
    state[7] = 0;
}
void button9_released() {
    state[8] = 0;
}
void button10_released() {
    state[9] = 0;
}

/* Function that performs Text-Entry algorithm.
Input: Button state array.
Output: Next character to display. */
char get_next_char(int state[]) {
    char next_char;
    if (state[9]) {
        /*Space bar*/
        next_char = alphabet_map[26];
    } else if (state[0]) {
        /*A - H*/
        for (int j = 1; j < 9; j++) {
            if (state[j]) {
                next_char = alphabet_map[j - 1];
                break;
            }
        }
    } else if (state[1]) {
        /*I - O*/
        for (int j = 2; j < 9; j++) {
            if (state[j]) {
                next_char = alphabet_map[j + 6];
                break;
            }
        }       
    } else if (state[2]) {
        /*P - U*/
        for (int j = 3; j < 9; j++) {
            if (state[j]) {
                next_char = alphabet_map[j + 12];
                break;
            }
        }
    } else if (state[3]) {
        /*V - Z*/
        for (int j = 4; j < 9; j++) {
            if (state[j]) {
                next_char = alphabet_map[j + 17];
                break;
            }
        }
    } else {
        next_char = NULL;
    }
    return next_char;
}

int main() {

    /* Setup buttons. */
    button1.mode(PullDown);
    button2.mode(PullDown);
    button3.mode(PullDown);
    button4.mode(PullDown);
    button5.mode(PullDown);
    button6.mode(PullDown);
    button7.mode(PullDown);
    button8.mode(PullDown);
    button9.mode(PullDown);
    button10.mode(PullDown);

    /*Add callback functions for events when buttons are pressed. */
    button1.attach_asserted(&button1_pressed);
    button2.attach_asserted(&button2_pressed);
    button3.attach_asserted(&button3_pressed);
    button4.attach_asserted(&button4_pressed);
    button5.attach_asserted(&button5_pressed);
    button6.attach_asserted(&button6_pressed);
    button7.attach_asserted(&button7_pressed);
    button8.attach_asserted(&button8_pressed);
    button9.attach_asserted(&button9_pressed);
    button10.attach_asserted(&button10_pressed);

    /*Add callback functions for events when buttons are released. */
    button1.attach_deasserted(&button1_released);
    button2.attach_deasserted(&button2_released);
    button3.attach_deasserted(&button3_released);
    button4.attach_deasserted(&button4_released);
    button5.attach_deasserted(&button5_released);
    button6.attach_deasserted(&button6_released);
    button7.attach_deasserted(&button7_released);
    button8.attach_deasserted(&button8_released);
    button9.attach_deasserted(&button9_released);
    button10.attach_deasserted(&button10_released);

    button1.setAssertValue(0);
    button2.setAssertValue(0);
    button3.setAssertValue(0);
    button4.setAssertValue(0);
    button5.setAssertValue(0);
    button6.setAssertValue(0);
    button7.setAssertValue(0);
    button8.setAssertValue(0);
    button9.setAssertValue(0);
    button10.setAssertValue(0);

    button1.setSampleFrequency();
    button2.setSampleFrequency();
    button3.setSampleFrequency();
    button4.setSampleFrequency();
    button5.setSampleFrequency();
    button6.setSampleFrequency();
    button7.setSampleFrequency();
    button8.setSampleFrequency();
    button9.setSampleFrequency();
    button10.setSampleFrequency();

    char curr_char = NULL;
    char next_char;

    /*Loop forever. */
    while(1) {
        next_char = get_next_char(state);
        if (!next_char) {
            curr_char = next_char;
        }

        if (next_char != curr_char) {
                pc.printf("%c", next_char);
                curr_char = next_char;
        }
        wait(.2);
    }

}