#include "mbed.h"
#include <ctype.h>
#include "FastPWM.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
FastPWM pwm(p21);
DigitalOut trigger(p22);
//AnalogIn analog_value(p20);
Serial pc(USBTX, USBRX);
double dutyCycle=.01;


void seekPWM(double newDuty)
{
    if (dutyCycle<0.01 or newDuty <0.01)
    {
        if (newDuty > dutyCycle) {
            while (newDuty/dutyCycle > 2) {
                dutyCycle = dutyCycle * 1.5;
                trigger=0;
                pwm.write(dutyCycle);
                trigger=1;
                wait_ms(100);
            }
        } else {
            while (newDuty/dutyCycle < .5) {
                dutyCycle = dutyCycle * 0.75;
                trigger=0;
                pwm.write(dutyCycle);
                trigger=1;
                wait_ms(100);
            }
        }
    }    
    trigger=0;
    dutyCycle = newDuty;
    pwm.write(dutyCycle);    
    trigger=1;


}    
    
int main() {
    char current_char=0;
    
    // specify period first
    //led.period(0.0050f);      // 200 Hz
    //pwm.period(0.0100f);      // 100 Hz
    
    pwm.period_ms(10);
    //led.write(0.10f);      // 10% duty cycle, relative to period
    pwm.write(dutyCycle);       // 1%
    //led = 0.5f;          // shorthand for led.write()
    //led.pulsewidth(2);   // alternative to led.write, set duty cycle time in seconds

    
    while(1)
    {
       
        pc.printf("Current duty cycle = %f \r\n ", dutyCycle); 
        pc.printf("U  to increase duty cycle \r\n ");  
        pc.printf("D  to decrease duty cycle \r\n ");     
        pc.printf("R  to ramp duty cycle \r\n ");     
        pc.printf("Command?");
        current_char = pc.getc();
        pc.printf("%c\n\r",current_char);
        
        switch (tolower(current_char))
        {
            
            case 'u':
            {
                dutyCycle = dutyCycle + 0.0002;
                trigger=1;
            }
            break;
            case 'd':
            {
                dutyCycle = dutyCycle - 0.0002;
                trigger=1;
            }
            break;
            case 'r':
            {
                trigger = 0;
                seekPWM(0.0001);
                wait(1.0);
                trigger=0;
                seekPWM(0.05);
                trigger=0;
                /*
                trigger=0;
                dutyCycle = 0.001;
                pwm.write(dutyCycle);
                wait(1.0);
                //int pulseWidthUs = 10;
                for (int i=0; i< 10;i++)
                {
                    trigger=1;
                    pwm.write(dutyCycle);
                    //pwm.pulsewidth_us(pulseWidthUs);
                    pulseWidthUs *= 2;
                    wait_ms(10);
                    trigger=0;
                    wait(1.0);
                    
                    //dutyCycle = dutyCycle+(.0001);
                    pulseWidthUs = pulseWidthUs + 10;
                    led1.write(i&0x01);
                    led2.write((i&0x02)>>1);
                    led3.write((i&0x04)>>2);
                    led4.write((i&0x08)>>3);
                }
                */
                    
            }
            break;
        }
        dutyCycle = dutyCycle < 1.0 ? dutyCycle : 1.0;
        dutyCycle = dutyCycle > 0.0001 ? dutyCycle : 0.0001;
        pwm.write(dutyCycle);
        wait_ms(10);
        trigger=0;
        
    } 
}