#include "mbed.h" //Importing mbed header files
#include "MMA8451Q.h" //Importing libraries to get accelerometer values
#define MMA8451_I2C_ADDRESS (0x1d<<1) //Setting Accelerometer address
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS); //Initializing accelerometer pins and address
BusOut led(PTB18,PTB19,PTD1); //BusOut to control ON/OFF state of 3 LEDs
Serial pc(USBTX,USBRX);
int i=0; //Counter to toggle light color
int xvali,yvali,zvali; //Variable to get value of Y axis of accelerometer

int main()
{
    led=0x7; //Ensure all LEDs are off initially
    while(1) 
    {
        xvali = (acc.getAccX()+1)*100; //Getting value of X axis acceleration
        yvali = (acc.getAccY()+1)*100; //Getting absolute value of Y axis acceleration
        zvali = (acc.getAccZ()+1)*100; //Getting absolute value of Z axis acceleration
        pc.printf("$%d %d %d;",xvali,yvali,zvali);
        if(xvali>250||yvali>250||zvali>250) //Initialize shake loop, once execution enters this loop, at least one LED change SHOULD BE visible
        {            
                        if(i==0) //Turn on only red LED once every three light swithches
                        {
                            led=0x06;
                        }
                        else if(i==1) //Turn on only green LED once every three light swithches
                        {
                            led=0x05;
                        }
                        else if(i==2) //Turn on only blue LED once every three light swithches
                        {
                            led=0x03;
                        }
                        i++; //Increment counter
                        if(i==3) //Ensure counter always increments between 0 to 2
                        {
                            i=0;
                        }
                        wait(1);
        }
    } //Infinite loop to keep measuring Y axis acceleration
}
