/*******************************************************************************
 * Copyright (c) 2017 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Lokesh K Haralakatta  Initial implementation 
 *******************************************************************************/
#include "DeviceClient.h"
#include "Command.h"
using namespace IoTF;

// Callback Method to process the received command by the device
void processCommand(IoTF::Command &cmd)
{
    printf("Command received name: %s, payload: %s\r\n", cmd.getCommand(), cmd.getPayload());
}

int main() {

    // Set Watson IoT Platform connection parameters
    // Update the below parameters with actual values before build and execution of sample
    char *orgId = "OrganizationID"; // Replace with correct organization ID
    char *deviceType = "DeviceType"; // Replace with correct device type as registered on WIoTP
    char *deviceId = "DeviceID"; // Replace with correct device ID as registered on WIoTP
    char *method = "token"; // Retain this as token for authentication method
    char *token = "DeviceToken"; // Replace with device token as obtained from WIoTP
    int port = 8883; // Secure port can be either 8883 or 443
    
    // Create DeviceClient Instance using above connection parameters
    DeviceClient *client = new DeviceClient(orgId,deviceType,deviceId,method,token,port);
    
    // Call Device Client connect method to establish secure connection to Watson IoT Platform
    if(client->connect()){
        //Device Client Connected to Watson IoT Platform
        printf("Client Connected to WIoTP\r\n");
        
        //Subscribe to device commands with CMD Callback to process the received command
        client->setCommandCallback(processCommand);
        
        // Create buffer to hold the event
        char buf[50];
        int count = 0;
        sprintf(buf,"{\"d\":{\"temp\":\"35\"}}");
        
        // Keep publishing the 10 device events for every 3 seconds
        while(1){
           client->publishEvent("evt", buf);
           wait(3);
           count++;
           if(count == 10)
             break;
        }
        
        // Disconnect Device Client from WIoTP if still in connected state
        if(client->isConnected()){
           printf("Disconnecting the client from server...\r\n");
           client->disconnect();
        }
        else
           printf("Client already disconnected from server...\r\n");
    }
    else
        printf("Client Not Connected to WIoTP\r\n");

    //Release resources allocated to Device Client
    delete client;
    
    printf("!!! Done !!!\r\n");
    return 0;
}