/*******************************************************************************
 * Copyright (c) 2015 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Sathisumar Palaniappan - initial implementation
 *    Sathisumar Palaniappan - added reconnect logic and isConnected() method
 *    Lokesh K Haralakatta - Port to mbed OS 5 support
 *    Lokesh K Haralakatta - Added SSL/TLS Support
 *******************************************************************************/

#ifndef DeviceClient_H
#define DeviceClient_H

#include "MQTTmbed.h"
#include "MQTTClient.h"
#include "MQTTNetwork.h"
#include "Command.h"

// Update this to the next number *before* a commit
#define __APP_SW_REVISION__ "1.0"

// Configuration values needed to connect to IBM IoT Cloud
#define QUICKSTART "quickstart"

#define MQTT_PORT 1883
#define MQTT_TLS_PORT 8883

#define IBM_IOT_MESSAGING ".messaging.internetofthings.ibmcloud.com"
#define CONNECT_TIMEOUT 1000 * 60
#define MQTT_MAX_PACKET_SIZE 250

typedef void (*CommandHandler)(IoTF::Command &cmd);

namespace IoTF {
    class DeviceClient
    {
        private:
            bool connected;
            char *org;
            char *deviceType;
            char *deviceId;
            char *authMethod;
            char *authToken;
            int port;
            MQTTNetwork* mqttNetwork;
            MQTT::Client<MQTTNetwork, Countdown> *mqttClient;

            bool tryConnect(char *hostname, MQTTPacket_connectData &data);
            int getConnTimeout(int attemptNumber);
            void logData(NetworkInterface* net, char *hostname, char *clientId);
            int subscribeToCommands();
            char* getMac(char* buf, int buflen);

            DeviceClient();
        public:
            DeviceClient(char *org, char *deviceType, char *deviceId, int port = MQTT_PORT);
            DeviceClient(char *org, char *deviceType, char *deviceId, char *authMethod, char *authToken, int port = MQTT_PORT);
            bool publishEvent(char *eventName, char *data, MQTT::QoS qos = MQTT::QOS0);
            void setCommandCallback(CommandHandler callbackFunc);
            char* getDeviceId(char* buf, int buflen);
            void yield(int ms);
            bool isConnected();
            bool connect();
            bool disconnect();
            bool reConnect();
     };
}
#endif
