#include "mbed.h"
#include "SDFileSystem.h"
#include <time.h>

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
/* UD-GS2 H/W define
 PIO_SWin    PB_4
 PIO_wkup    PA_4
 PIO_enable  PB_0
 PIO_intout1 PB_2
 PIO_led     PB_5
 PIO_v20v    PC_13
 PIO_v18v    PH_0
 PIO_intout2 PH_1
 PIO_spics   PB_12
 PIO_battryMonEn   PA_5
 PB_7 SDA
 PB_6 SCL

*/
//DigitalOut hx_clk(PB_7);
//DigitalIn hx_dt(PB_6);
//I2C               i2cacc(p_sda, p_scl)

//#include "H3LIS331DL.h"

//#define TIMEINTERVAL

//キャリブレーション　仮値
#define OFFSET_X   0
#define OFFSET_Y   0
#define OFFSET_Z   0

HAL_StatusTypeDef writeEEPROMByte(uint32_t address, uint8_t data);
uint8_t readEEPROMByte(uint32_t address);


//H3LIS331DL  h3dacc(PB_7,PB_6);
I2C i2c(PB_7,PB_6);                          //NUCLEO pin assign

RawSerial         pc(PA_9, PA_10,115200); //console UART
//LowPowerTicker    interrupt;
//Ticker    interrupt;
SPI               STSPI(PB_15, PB_14, PB_13); //mosi,miso,clk
DigitalOut        STSPICS(PB_12);

SDFileSystem *sd = new SDFileSystem(PA_12, PA_11, PB_3, PA_15, "sd"); // mosi, miso, sclk, cs, name

DigitalOut        led(PB_5);
int initLIS3DH();
int read3axes(short *tx,short *ty,short *tz);
int initLIS331();
int read3axes331(short *tx,short *ty,short *tz);
int int_sqrt(unsigned int x);
//int readTemp(short *tmp);
FILE     *fp1,*fp2;//fp1:H3LIS331DL, fp2:LIS3DH
unsigned long timecount = 0;
int oldcount = 0;
//uint8_t maxacc = 0;
float max_g=0;
float now_g=0;
int  update=0;
char buffer1[512] = {};
char buffer2[512] = {};
char stracc1[64] = {}, stracc2[32] = {};
 int lognum1 = 0, lognum2 = 0;
char filename1[32]= {};
char filename2[32]= {};
int ret = 0,init=1;
//int timer_flag = 0;

/*
void timer(){
    timer_flag = 1;
    timecount++;
    oldcount++;
}
*/

void sub(){
    short tx=0,ty=0,tz=0;
    //float scr=0;
    long scr = 0;
    //static long ax,ay,az,as;
    //static  int cnt;
    
    read3axes331(&tx,&ty,&tz);
    //キャリブレーションの補正
    tx += OFFSET_X;
    ty += OFFSET_Y;
    tz += OFFSET_Z;
    
    //スカラー値変換
    scr = int_sqrt( tx*tx  + ty*ty + tz*tz);// 195mg/digit
    now_g = scr;
    
    //ax+= tx;
    //ay+= ty;
    //az+= tz;
    //as+= scr;
    //cnt++;
    pc.printf("new x:%2.2f y:%2.2f,z:%2.2f scaler = %2.2f \r\n",(float)tx*0.005,(float)ty*0.005,(float)tz*0.005,(float)scr*0.005);
    //pc.printf("new x:%d y:%d,z:%d scaler = %d \r\n",tx,ty,tz,scr);
    
    if ( max_g < scr) {
        max_g = scr;
        update=1;
        //pc.printf("x:%d y:%d,z:%d scaler = %d  max g=%2.2fG \r\n",tx,ty,tz,scr,  (float)scr/11.0f);
        //pc.printf("new x:%d y:%d,z:%d scaler = %d  max g=%2.2fG \r\n",tx,ty,tz,scr,  (float)max_g/11.0f);
        //Save EEPROM
        writeEEPROMByte(0, max_g);
    }
    
    sprintf(stracc1,"%d,%2.2f,%2.2f,%2.2f,%2.2f\r\n",timecount,(float)tx*0.005,(float)ty*0.005,(float)tz*0.005,(float)scr*0.005);
    //pc.printf("h3lis331dl:%s",stracc1);
    if(strlen(buffer1)+strlen(stracc1) > 512) {
            //pc.printf("buffer over. write file2\r\n");
            
            ret = fprintf(fp1,"%s",buffer1);
             if(ret == 0){
                pc.printf("fp1 write failed. Reboot!!!\r\n");
                NVIC_SystemReset();
            }
            
            
            memset(buffer1,0,sizeof(buffer1));
            sprintf(buffer1,"%s",stracc1);
        
        } else {
            sprintf(buffer1,"%s%s",buffer1,stracc1);
        }
    
    if(oldcount == 10){
        //LIS3DH
        read3axes(&tx,&ty,&tz);
        scr = int_sqrt( tx*tx  + ty*ty + tz*tz);
        pc.printf("old x:%d y:%d,z:%d scaler = %d  max g=%2.2fG \r\n",tx,ty,tz,scr,  (float)max_g/11.0f);
        sprintf(stracc2,"%d,%d\r\n",timecount,scr);
        //pc.printf("lis3dh:%s",stracc2);
        if(strlen(buffer2)+ strlen(stracc2)> 512) {
            
            ret = fprintf(fp2,"%s",buffer2);
            if(ret == 0){
                pc.printf("fp2 write failed. Reboot!!!\r\n");
                NVIC_SystemReset();
            }
            
            memset(buffer2,0,sizeof(buffer2));
            sprintf(buffer2,"%s",stracc2);
        } else {
            sprintf(buffer2,"%s%s",buffer2,stracc2);
        }
        oldcount = 0;
    }

    if(time(NULL) > 86400){
            //Create New File
            set_time(NULL);
            timecount = 0;
            fclose(fp1);
            fclose(fp2);
            lognum1++;
            lognum2++;
            sprintf(filename1,"/sd/new_%d",lognum1);
            sprintf(filename2,"/sd/old_%d",lognum2);
            fp1 = fopen(filename1,"a");
            if(!fp1){
                pc.printf("fp1 create file failed\r\n");
                NVIC_SystemReset();
                }
            fp2 = fopen(filename2,"a");
            if(!fp2){
                pc.printf("fp2 create file failed\r\n");
                NVIC_SystemReset();
            }
        }
        
        
        //timer_flag = 0;
}

int main()
{
    //h3dacc.init(H3LIS331DL_ODR_50Hz, H3LIS331DL_NORMAL,H3LIS331DL_FULLSCALE_8);//これで初期化している FULLSCALE_8=400G
    //h3dacc.setHPFMode(H3LIS331DL_HPM_NORMAL_MODE_RES);//High Pass Filter ON
    //h3dacc.setHPFCutOFF(H3LIS331DL_HPFCF_1);

    sprintf(filename1,"/sd/new_%d",lognum1);
    sprintf(filename2,"/sd/old_%d",lognum2);

    fp1 = fopen(filename1,"a");
    if(!fp1) {
        pc.printf("fp1(%s) open failed\r\n",filename1);
        //NVIC_SystemReset();
    }
    fp2 = fopen(filename2,"a");
    if(!fp2) {
        pc.printf("fp2(%s) open failed\r\n",filename2);
        //NVIC_SystemReset();
    }

    while(init) {
        init = initLIS331();
        initLIS3DH();
        pc.printf(" init acc sensor %d\r\n",ret);
        wait_ms(100);
    }
    //interrupt.attach_us(&timer,20000);//20ms
    while(1)
    {
        //if(timer_flag){
            sub();
            timecount++;
            oldcount++;
        //}
        wait_ms(200);
    }
    
}
/*********** porting **************/
void spiFormat(int b,int m)
{
    STSPI.format(b,m);  /* 8bit */
}
void spiFrequency(int f)
{
    STSPI.frequency(f); /* 1Mbps */
}
void spiWriteCS(int cs)
{
    STSPICS=cs;
}
int spiWrite(int wd)
{
    return ( STSPI.write(wd));
}

/*******************************************************
  EEPROM WRITE
********************************************************/  
HAL_StatusTypeDef writeEEPROMByte(uint32_t address, uint8_t data)
 {
    HAL_StatusTypeDef  status;
    address = address + 0x08080000;
    HAL_FLASHEx_DATAEEPROM_Unlock();  //Unprotect the EEPROM to allow writing
    status = HAL_FLASHEx_DATAEEPROM_Program(TYPEPROGRAMDATA_BYTE, address, data);
    HAL_FLASHEx_DATAEEPROM_Lock();  // Reprotect the EEPROM
    return status;
}

/*******************************************************
  EEPROM READ 
********************************************************/  
uint8_t readEEPROMByte(uint32_t address) {
    volatile uint8_t tmp ;
    address = address + 0x08080000;
    tmp = *(__IO uint8_t*)address;
    return tmp;
}

/***************************
  integer sqrt
    整数 sqrt √演算を整数で　ライブラリより速い
****************************/
int int_sqrt(unsigned int x)
{
  register int a = 0, c = 0, y = 0, i = 0, t = x;
  while(t >>= 1){
    ++i;
  }
  for(i += i & 1; i >= 0; i -= 2){
    c = (y << 1 | 1) <= x >> i;
    a = a << 1 | c;
    y = y << 1 | c;
    x -= c * y << i;
    y += c;
  }
  return a;
}