#include "mbed.h"
#include "SDFileSystem.h"
/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
/* UD-GS2 H/W define 
 PIO_SWin    PB_4 
 PIO_wkup    PA_4 
 PIO_enable  PB_0
 PIO_intout1 PB_2
 PIO_led     PB_5
 PIO_v20v    PC_13
 PIO_v18v    PH_0
 PIO_intout2 PH_1
 PIO_spics   PB_12
 PIO_battryMonEn   PA_5
 PB_7 SDA
 PB_6 SCL
 
*/
//DigitalOut hx_clk(PB_7);
//DigitalIn hx_dt(PB_6);
//I2C               i2cacc(p_sda, p_scl)

#include "H3LIS331DL.h"

H3LIS331DL  h3dacc(PB_7,PB_6);


RawSerial         pc(PA_9, PA_10,115200); //console UART
LowPowerTicker    interrput;
SPI               STSPI(PB_15, PB_14, PB_13); //mosi,miso,clk
DigitalOut        STSPICS(PB_12);

SDFileSystem *sd = new SDFileSystem(PA_12, PA_11, PB_3, PA_15, "sd"); // mosi, miso, sclk, cs, name

DigitalOut        led(PB_5);
int initLIS3DH();
int read3axes(short *tx,short *ty,short *tz);
int readTemp(short *tmp);
FILE     *fp;

int main()
{
    short x,y,z,tmp;
 
    int   i,l;
    int lwaight;
    float wt;
    uint32_t dt;
#if 0    
    pc.printf("\nSTM32 Loadcell  example\r\n");
    while(1) {
        led = !led;
        hx_clk=1;
        wait(1.0);
        hx_clk=0;
        wait(1.0);
        dt=0;
        for(i=0;i<24;i++) {
           hx_clk=1;
           wait_us(1);
           dt <<= 1;
           if (hx_dt==0) dt |= 1;
           hx_clk=0;
           wait_us(1);
        }
           hx_clk=1;
           wait_us(1);
           hx_clk=0;
        pc.printf("data = %08x %d ",dt,dt);
        wt =  (float)(dt) * 0.000038f  - 1.2f;          
        pc.printf("waight = %3.3f\r\n",wt); 
    }
#endif
 
    initLIS3DH();
 
     h3dacc.init(H3LIS331DL_ODR_100Hz, H3LIS331DL_NORMAL,H3LIS331DL_FULLSCALE_2);//これで初期化している
 
    pc.printf("\nSTM32 ADC internal channels reading example\r\n");
    pc.printf("\nSTM32 3D acc sensor example\r\n");
    
    fp = fopen("/sd/testlog.txt", "a");             
         
    if (fp == NULL)
    {
      pc.printf("open error!!\r\n");

    }     
    else
    {
      pc.printf("SD opened\r\n");
      fclose(fp);
      wait_ms(10);
    }
    
    while(1) {
//        pc.printf("ADC Temp = %f\r\n", (adc_temp.read()*100));
//        pc.printf("ADC VRef = %f\r\n", adc_vref.read());         
//        pc.printf("\033[2A");
//On board ACC sensor
        x=y=z=0;
        read3axes(&x,&y,&z);
        readTemp(&tmp);
        pc.printf("x=%d y=%d z=%d tmperature=%d\r\n", x,y,z,tmp);         
        pc.printf("x=%f y=%f z=%f\r\n", (float)x/1024.0f,(float)y/1024.0f,(float)z/1024.0f);   
// Extra ACC sensor        
        x=y=z=0;
        h3dacc.readXYZ(&x, &y, &z);
        pc.printf("High x=%d y=%d z=%d \r\n", x,y,z);         
              
        led = !led;
        wait(1.0);
    }
}
/*********** porting **************/   
void spiFormat(int b,int m) {
   STSPI.format(b,m);  /* 8bit */
}
void spiFrequency(int f){
    STSPI.frequency(f); /* 1Mbps */
}
void spiWriteCS(int cs) {
    STSPICS=cs;
}
int spiWrite(int wd) {
    return ( STSPI.write(wd)); 
}   
