#include "mbed.h"
//リレーを介して、ロデオボーイを強モードで動かし続けるためのプログラム
/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

AnalogIn adc_temp(ADC_TEMP);
AnalogIn adc_vref(ADC_VREF);
Ticker     interrput;
/* UD-GS2 H/W define 
 PIO_SWin    PB_4 
 PIO_wkup    PA_4 
 PIO_enable  PB_0
 PIO_intout1 PB_2
 PIO_led     PB_5
 PIO_v20v    PC_13
 PIO_v18v    PH_0
 PIO_intout2 PH_1
 PIO_spics   PB_12
 PIO_battryMonEn   PA_5
*/

RawSerial         pc(PA_9, PA_10,115200); //console UART
//LowPowerTicker    interrput;
SPI               STSPI(PB_15, PB_14, PB_13); //mosi,miso,clk
DigitalOut        relay1(PA_11);
DigitalOut        relay2(PA_8);
DigitalOut        STSPICS(PB_12);      
DigitalOut        led(PB_5);
int initLIS3DH();
int read3axes(short *tx,short *ty,short *tz); //read3axesという関数がmbedにあって、それを呼び出してる
int readTemp(short *tmp);
int tmr = 0;
int cnt = 0;
int i = 0;
int j = 0;
int m = 0;
int n = 0;

void timer(){ //xの値で動いていないと判断したとき
   tmr++;
   if(tmr > 15)
   {
       tmr = 0;
       
       for(i=0;i<2; i++)// 強モードまでボタン3回押す。
       {
         relay1 = !relay1;
         wait(1);
       }
       wait(2);
       for(j=0; j<4; j++)
       {
         relay2 = !relay2;
         wait(0.6);
       }
   }
   
}

int main()
{
    initLIS3DH();
    short x,y,z,tmp;
    
    pc.printf("\nSTM32 ADC internal channels reading example\r\n");
    
    pc.printf("-----RODEOBOY MODE = HIGH POWER START------\r\n");
 
    for(m=0;m<2; m++)// 強モードまでボタン3回押す。
    {
      relay1 = !relay1;
      wait(0.5);
    }
    wait(2);
    for(n=0;n<4; n++)// 強モードまでボタン3回押す。
    {
      relay2 = !relay2;
      wait(0.6);
    }
    
    interrput.attach(&timer, 60);//1分ごとに刻み、15分経つとロデオが自動OFF想定なので、そのタイミングで再び動作させる。
  
    while(1) {
//        pc.printf("ADC Temp = %f\r\n", (adc_temp.read()*100));
//        pc.printf("ADC VRef = %f\r\n", adc_vref.read());         
//        pc.printf("\033[2A");


        read3axes(&x,&y,&z);
        readTemp(&tmp);
        pc.printf("x=%d y=%d z=%d \r\n", x,y,z);         //上のread関数とprintfのところにtmpも追加すると、温度も分かります。
        pc.printf("x=%f y=%f z=%f\r\n", (float)x/1024.0f,(float)y/1024.0f,(float)z/1024.0f);      
        if(z>1050){
            cnt++;
            pc.printf("/////////count = %d ///////////\r\n",cnt);
        }
        led = !led;
        wait(0.1);
    }
}
/*********** porting **************/   
void spiFormat(int b,int m) {
   STSPI.format(b,m);  /* 8bit */
}
void spiFrequency(int f){
    STSPI.frequency(f); /* 1Mbps */
}
void spiWriteCS(int cs) {
    STSPICS=cs;
}
int spiWrite(int wd) {
    return ( STSPI.write(wd)); 
}   
