#include  "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include  <time.h>

//#include "udgs1.h"
#define ACC_OK 0
//SPI STSPI(SPI_MOSI, SPI_MISO, SPI_SCK);
/*******************************************
int initLIS3DH();
int read3axes(short *tx,short *ty,short *tz);
int readTemp(short *tmp);
******************************************/

unsigned char spiwriteReg(unsigned char ad,unsigned char val);
int spireadRegs(unsigned char ad,unsigned char *p,int bytes);
unsigned char spireadReg(unsigned char ad);
extern void spiFormat(int b,int m);
extern void spiFrequency(int f);
extern void spiWriteCS(int cs);
extern int  spiWrite(int  wd);
#define LIS2DW12_ID 0x44
/*****************************************
  init LIS2DW12 LIS3DH ST micro 3-axes accelerometer
   SPI interface 
*****************************************/
int initLIS3DH()
{
//    STSPI = new SPI(SPI_MOSI, SPI_MISO, SPI_SCK, D6);
   
    spiFormat(8,3);  /* 8bit */
    spiFrequency(1000000); /* 1Mbps */
    spiWriteCS(1);
    wait_us(1);
   // printf("Who am I %02x\r\n", spireadReg(0x0f));
    spiwriteReg(0x21,0x84);  // boot on
    spiwriteReg(0x1f,0xc0);  // 
    spiwriteReg(0x20,0x35);  // 25hz 14bit
    spiwriteReg(0x25,0x14);  // max 4G
  //  spiwriteReg(0x23,0x98);  
    return (spireadReg(0x0f) - LIS2DW12_ID);
}

/*************************************************
  read 3-axes from LIS3DH
*************************************************/
int read3axes(short *tx,short *ty,short *tz)
{
    int timeout=5;
    unsigned char regs[6];
    wait_us(50);
    while((spireadReg(0x07)&7)==0 && timeout--){wait_us(5);};
    spireadRegs(0x28,regs,6);// 14bit signed   1G = 413 9.8m/s**2
//    STSPI.frequency(); //1MHz
    *tx = (short)(regs[0] | (regs[1]<<8)) >> 3;
    *ty = (short)(regs[2] | (regs[3]<<8)) >> 3;
    *tz = (short)(regs[4] | (regs[5]<<8)) >> 3;
    return(ACC_OK);
}

/*************************************************
  read temparture from LIS3DH -105 to  +152 degree
*************************************************/
int readTemp(short *tmp)
{
    signed char t;
    t = spireadReg(0x26) + 25;
    if (tmp) *tmp = t;
    return(t);
}


/*************************************************
  Read a regster from SPI
*************************************************/
unsigned char spireadReg(unsigned char ad){
    unsigned char r;
    spiWriteCS(0);
    wait_us(1);
    spiWrite(ad | 0x80);  
    r = spiWrite(0);
    wait_us(1);
    spiWriteCS(1);
    return(r);
}

/*************************************************
  Read multi regsters from SPI
*************************************************/
int spireadRegs(unsigned char ad,unsigned char *p,int bytes){
#if 0
   while(bytes--) {
      *p = spireadReg( ad );
      p++;
      ad++;
   }    
#else   
   spiWriteCS(0);
    wait_us(1);
    spiWrite(ad | 0x80 );  
   while(bytes--) {
      *p++ = spiWrite(0);
   }
   wait_us(1);
   spiWriteCS(1);
#endif  
    return(ACC_OK);
}

/*************************************************
  Write a regster via SPI
*************************************************/
unsigned char spiwriteReg(unsigned char ad,unsigned char val){
    unsigned char r;
    spiWriteCS(0);
    wait_us(1);
    spiWrite(ad);  
    r = spiWrite(val);
    wait_us(1);
    spiWriteCS(1);
    return(r);
}




