#include "mbed.h"

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/
DigitalIn     mode(PC_13);
DigitalOut    nRF_csn(D10 /*PB_6*/ );
DigitalOut    nRF_ce(D9);
DigitalIn     IRQ(D8);
//SPI           nRF_spi(D4, D5, D3);// mosi, miso, sck,
SPI           nRF_spi(PA_7, PA_6, PA_5);// mosi, miso, sck

int main()
{
    printf("SPI TEST\r\n");
    nRF_csn=1;//chip select disable
    nRF_spi.frequency(4000000);     // 1MHz SPI bus
    nRF_spi.format(8,0);  // 8bit normal porarity phase
    wait(1.0);
    int i;
    int reg;
    i=0;
    
    while(1) {
      nRF_csn=0;//chip select enable
      nRF_spi.write(i);//register read command  I=register number
      reg = nRF_spi.write(i);//read reg value
      nRF_csn=1; //chip select disable
      printf("%d %02x \r\n",i,reg);
      i++;     
      if (i>=32) i=0;
      wait(0.1f);   
    }
}
