#include "mbed.h"

DigitalOut led(LED1);
//InterruptIn event(USER_BUTTON);
DigitalIn button(USER_BUTTON);
RawSerial pc(PA_2, PA_3,115200 );

DigitalIn l_button(D4,PullUp); 
DigitalIn r_button(D3,PullUp); 

InterruptIn event(USER_BUTTON);
Ticker      interrput;


char bdata[20][20]={
 2,2,2,2,2 ,2,2,2,2,2, 2,2,2,2,2 ,2,2,2,2,2,  
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,1,0,0,1, 1,0,1,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,0,0,0,0 ,0,0,0,0,0, 0,0,0,0,0 ,0,0,0,0,2, 
 2,2,2,2,2 ,2,2,2,2,2, 2,2,2,2,2 ,2,2,2,2,2,  
};
  


void cur_down()
{
        pc.printf("\033B");
}

void cur_up()
{
        pc.printf("\033A");
}



void cur_left()
{
        pc.printf("\033D");
}

void cur_right()
{
        pc.printf("\033C");
}

void cur_xy(int x,int y)
{
    pc.printf("\033[%d;%dH",y,x);
}

void clear_all()
{
    pc.printf("\033[2J\033[6m");//clear , under line
    cur_xy(0,0);
}

void init_bd()
{
    int x;
    int  y;
    pc.printf("\033[2J");//clear 
    for(y=0;y<20;y++) {
        cur_xy(1,y+1);
        for(x=0;x<20;x++) {
            if (bdata[y][x]==2) pc.printf("H"); 
            else if (bdata[y][x]==1) pc.printf("@"); 
            else pc.printf(" ");
        }
    }
}

int    dx=1;//横移動
int    dy=1;//縦移動

/* GPIO 割り込み */
void pressed()
{
    //pc.printf("Button pressed\n");
    dx = -dx;//横　動きを逆に
}

/* タイマー割り込み */
void intTimer()
{
    led = !led;
}

int main()
{
    int    i;
    int    x;
    int    y;
    clear_all();                       //画面クリア　  
    event.fall(&pressed);              //ボタン押した時、 立下りエッジ割り込みの関数設定
    interrput.attach(&intTimer, 0.5f); //0.5秒タイマーで割り込みの関数設定
    
    pc.printf("\nStart example\n");
    init_bd();//ブロックデータの初期化
    x=2;//横 初期位置
    y=0;//縦 初期位置
    i=0;
    while(1) {
        //範囲越え判定  
        if (y>=17) dy=-1;
        if (x>=19) dx=-1;
        if (y<=0) dy=1;
        if (x<=0) dx=1;
        //移動計算
        x=x+dx;
        y=y+dy;
        cur_xy(x+1,y+1);     //カーソル座標設定
        if (bdata[y][x]==1) { //当たり判定
             bdata[y][x]=0; //ブロックをなくす
             pc.printf(" "); //@を消す
             cur_xy(x+1,y+1);//カーソルを戻す
             pc.printf("\007");//ベル音
        }
        
        wait(0.1f);
        //ボタン操作
//        if (button==0) dx = -dx;
//       dx=0;
//       if (l_button==0) dx= -1;
//       else if (r_button==0) dx=  1;

         //パドル表示
          if (x<=1){
               cur_xy(1,19);  //カーソル座標設定
               pc.printf("HXX ");
          } else if (x>=17) { 
              cur_xy(17,19);  //カーソル座標設定
              pc.printf(" XXH");
          } else {
               cur_xy(x,19);//カーソル
               pc.printf(" XX ");
          }
          cur_xy(x+1,y+1);//カーソルを戻す
        i++;
        if (i==100) __disable_irq(); // 禁止
        else if(i==200) __enable_irq(); // 許可
          
    }  
    
}


