
//受信用プログラム

#include "mbed.h"
#include "nRF24L01P.h"
RawSerial  pc(PA_2, PA_3,115200);
AnalogIn   mic_in(A0);
AnalogOut  sp_out(A2);
Ticker     interrput;
#define TRANSFER_SIZE   16
int      out_flg = 0;
int      rcv_flg = 0;
uint16_t rxData[TRANSFER_SIZE*2];
int      rxDataIdx = 0;
int      rxDataCnt = 0;
 
nRF24L01P my_nrf24l01p(D11, D12, D13, D10, D9,D8);    // mosi, miso, sck, csn, ce, irq
//nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq


void timer(){     //タイマー割り込みによるSPEAKER out
      if(rcv_flg) {
         out_flg=1;     
      } 
      if(out_flg){    
        sp_out.write_u16(rxData[rxDataIdx]);
        rxDataIdx++;
        if (rxDataIdx >= TRANSFER_SIZE*2) rxDataIdx=0;
      }    
}

int main() {

  int bufferidx=0;
   int i=0;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);//2400-2525
    my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_12_DB);//mAX 0  -6 -12 -18
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);//250k,1000,2000K
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE * sizeof( uint16_t ) );//mAX 32
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    wait_ms(100);
   // my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char*)rxData,1);//dummy
    interrput.attach_us(&timer, 100);//100 usec 10Khz

 //   my_nrf24l01p.flush_rx_fifo();
    while (1) {
        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {    //受信?
            // ...read the data into the receive buffer
            if (rxDataIdx < 16) bufferidx = TRANSFER_SIZE;
            else bufferidx = 0; 
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, (char*)(rxData+bufferidx),TRANSFER_SIZE * sizeof( uint16_t ) );
            //myled1 = !myled1;
            //if (rcv_flg==0) 
            if ((i++ & 0xf) ==0) pc.putc('.');
            rcv_flg = 1;
        }
    }
}
