
//送信用プログラム

#include "mbed.h"
#include "nRF24L01P.h"
RawSerial  pc(PA_2, PA_3,115200);
AnalogIn   mic_in(A0);
AnalogOut  sp_out(A2);
Ticker     interrput;
#define TRANSFER_SIZE   16
int      out_flg = 1;
int      snd_flg = 0;
uint16_t txData[TRANSFER_SIZE*2];
int      txDataIdx = 0;
int      rxDataCnt = 0;
 
nRF24L01P my_nrf24l01p(D11, D12, D13, D10, D9,D8);    // mosi, miso, sck, csn, ce, irq
//nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq


void timer(){  //タイマー割り込みによるMic in　16回ごとに送信
      uint16_t ain;
      if(1 /*out_flg*/){    
        ain= mic_in.read_u16();
        txData[txDataIdx] = ain;
        txDataIdx++;
        if (txDataIdx == TRANSFER_SIZE) {//最初の16回
             snd_flg = 1;
        } else if (txDataIdx >= TRANSFER_SIZE*2){//後の16回
             txDataIdx=0;
             snd_flg = 2;
        } 
      //  pc.printf("in %d\r\n",ain);
      //  sp_out.write_u16(ain);
        //out_flg = 0;              
       }    
}

int main() {
// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
//  "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
//  only handles 4 byte transfers in the ATMega code.
    int i=0;
    wait_ms(100);

    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);//2400-2525
    my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_12_DB);//mAX 0  -6 -12 -18
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);//250k,1000,2000K
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE * sizeof( uint16_t ));//mAX 4

    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    wait_ms(10);
    interrput.attach_us(&timer, 100);//100 usec 10Khz

    while (1) {
         i++;
         if (snd_flg==1) {//最初のバッファ
               snd_flg=0;
               my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char *)txData , TRANSFER_SIZE * sizeof(uint16_t) );
              // pc.putc('1');
         }    
         else if (snd_flg==2)  {//後半のバッファ         
               snd_flg=0;
               my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char*)(txData+TRANSFER_SIZE) , TRANSFER_SIZE * sizeof(uint16_t) );
             //    pc.putc('2');

         }
   }   //for while(1)
}
