#include "mbed.h"
//UD-GS4  H3LIS331DL sensor test program
// i2c SPI switch by #define USESPI

/* UD-GS2 H/W define 
 PIO_SWin    PB_4 
 PIO_wkup    PA_4 
 PIO_enable  PB_0
 PIO_intout1 PB_2
 PIO_led     PB_5
 PIO_v20v    PC_13
 PIO_v18v    PH_0
 PIO_intout2 PH_1
 PIO_spics   PB_12
 PIO_battryMonEn   PA_5
 PB_7 SDA
 PB_6 SCL
 */

//I2C               i2cacc(p_sda, p_scl)
//#include "H3LIS331DL.h"
//DigitalIn sdaDummy(D14, PullUp);
//DigitalIn sclDummy(D15, PullUp);
//H3LIS331DL  h3dacc(PB_7,PB_6);
//H3LIS331DL  h3dacc(D14,D15);
//キャリブレーション　仮値
#define OFFSET_X   12
#define OFFSET_Y   22
#define OFFSET_Z   -7

//SPI (PinName mosi, PinName miso, PinName sclk, PinName ssel=NC)
SPI STSPI(PA_7, PA_6, PA_5);
DigitalOut  STSPICS(PB_6);

//             SDA SCL
I2C i2c(D14,D15);                          //NUCLEO pin assign
//RawSerial         pc(PA_9, PA_10,115200); //console UART UD-GS4
RawSerial          pc(PA_2, PA_3,115200 ); //NUCLEO pin assign

Ticker    interrput;
//Ticker    interrupt;
//DigitalOut led(LED1);
//int initLIS3DH();


int initLIS331();
int read3axes331(short *tx,short *ty,short *tz);


/***************************
  integer sqrt
    整数 sqrt √演算を整数で　ライブラリより速い
****************************/
int int_sqrt(unsigned int x)
{
  register int a = 0, c = 0, y = 0, i = 0, t = x;
  while(t >>= 1){
    ++i;
  }
  for(i += i & 1; i >= 0; i -= 2){
    c = (y << 1 | 1) <= x >> i;
    a = a << 1 | c;
    y = y << 1 | c;
    x -= c * y << i;
    y += c;
  }
  return a;
}

//#define PRINTMAX

long max_g=0;
long now_g;
int  update;
// SPIはtimer割り込みが使える 
void timer()
{
    
    short tx=0,ty=0,tz=0;
    long  scr;
    static long ax,ay,az,as;
    static  int cnt;
    
    read3axes331(&tx,&ty,&tz);
   //キャリブレーションの補正
    tx += OFFSET_X;
    ty += OFFSET_Y;
    tz += OFFSET_Z;
//    led = !led;

    //スカラー値
    scr = int_sqrt( tx*tx  + ty*ty + tz*tz);
    now_g = scr;
    
    ax+= tx;
    ay+= ty;
    az+= tz;
    as+= scr;
    cnt++;

#ifdef PRINTMAX
    if ( max_g < scr) {
        max_g = scr;
        update=1;
        pc.printf("x:%d y:%d,z:%d scaler = %d  max g=%2.2fG \r\n",tx,ty,tz,scr,  (float)scr/11.0f);
    }  
#else    
     pc.printf("x:%d\ty:%d\tz:%d\tscaler=%d\t%2.2fG \r\n",tx,ty,tz,scr,  (float)scr/11.0f);
#endif
    //16回平均
    if ((cnt & 0x0f)== 0) {
         float asc = (float)as / 11.0f /16.0f;
         pc.printf("avarage x:%d\ty:%d\tz:%d\tscaler=%d\t%2.2fG \r\n",ax/16,ay/16,az/16,as/16,  asc );
        as=ax=ay=az=0;
    }



}


int main()
{
    long gg;
    int i=0;
    int ret = 1;
    short tx=0,ty=0,tz=0;
     pc.printf("\nSTM32 Start \r\n");

     
#if 1 //i2c 
    while(ret) {
      ret = initLIS331();
      pc.printf(" init LIS331DL %d\r\n",ret);
      wait_ms(100);
    }
    while(1)
    {
        timer();
         wait_ms(20);
    }

#endif
#if 0//SPI     
    while(ret) {
       ret = initLIS331();
       pc.printf(" init LIS331DL %d\r\n",ret);
       wait_ms(100);
    }
    interrput.attach_us(&timer, 11650  );// 20ms

    while(1)
    {
        gg = now_g;
        if (update) {//maxが見つかったラ表示
            update=0;
            pc.printf("max g =%2.2f G \r\n", (float)max_g / 50.0f );
        } else if (gg > 50) pc.printf("now g =%2.2f G \r\n", (float)gg / 50.0f );
    //    led = !led;
        wait_ms(20);
    }
#endif    
}
