#include  "mbed.h"
#include <stdio.h>

#define H3LIS331DL_CTRL_REG1            0x20
#define H3LIS331DL_CTRL_REG2            0x21
#define H3LIS331DL_CTRL_REG3            0x22
#define H3LIS331DL_CTRL_REG4            0x23
#define H3LIS331DL_CTRL_REG5            0x24 
//STATUS_REG_AXIES 
#define H3LIS331DL_STATUS_REG           0x27   //

///i2c or SPI 
//#define USESPI 

//SPI STSPI(SPI_MOSI, SPI_MISO, SPI_SCK);
/*******************************************
int initLIS331();
int read3axes(short *tx,short *ty,short *tz);
int readTemp(short *tmp);
******************************************/


//mbed Class
//SPI STSPI(SPI_MOSI, SPI_MISO, SPI_SCK);
//SPI STSPI(D11, D12, D13);
//\\DigitalOut  STSPICS(D10);

#ifdef USESPI
///// SPI -
extern SPI STSPI;
extern DigitalOut  STSPICS;
/*********** porting **************/   
void spiFormat(int b,int m) {
   STSPI.format(b,m);  /* 8bit */
}
void spiFrequency(int f){
    STSPI.frequency(f ); /* 1Mbps */
}
void spiWriteCS(int cs) {
    STSPICS=cs;
}
int spiWrite(int wd) {
    return ( STSPI.write(wd)); 
}   
////////
#else 
//i2c /////
extern I2C i2c;
int deviceAddress = 0x18;
///////////
#endif
extern RawSerial          pc;
static unsigned char spireadReg(unsigned char ad);
static int spireadRegs(unsigned char ad,unsigned char *p,int bytes);
static unsigned char spiwriteReg(unsigned char ad,unsigned char val);
#define LIS331  0x32
/*****************************************
  init h3LIS331DL ST micro 3-axes accelerometer
   SPI interface 
*****************************************/
int initLIS331()
{
//    STSPI = new SPI(SPI_MOSI, SPI_MISO, SPI_SCK, D6);
#ifdef USESPI   
    spiFormat(8,3);  /* 8bit */
    spiFrequency(8000000); /* 8Mbps */
    spiWriteCS(1);
#else
#endif    
    wait_us(10);
    pc.printf("Who am I %02x\r\n", spireadReg(0x0f));
    spiwriteReg(H3LIS331DL_CTRL_REG1,0x27);  // power normal xyz enable out 50Hz 
    spiwriteReg(H3LIS331DL_CTRL_REG2,0x00);  // normal, no filter 
    spiwriteReg(H3LIS331DL_CTRL_REG3,0x00);  // no interrut
    spiwriteReg(H3LIS331DL_CTRL_REG4,0x30);  // BDU 1 BLE 0  fs 3 400g 
    spiwriteReg(H3LIS331DL_CTRL_REG5,0x00);  // max 400G
  //  spiwriteReg(0x23,0x98);  
    //spireadReg(0x25);
    return (spireadReg(0x0f) - LIS331);
}

  
/*************************************************
  read 3-axes from LIS3DH
*************************************************/
int read3axes331(short *tx,short *ty,short *tz)
{
    int timeout=5;
    unsigned char regs[6];
    wait_us(5);
    while((spireadReg(0x27)&7)!=7 && timeout--){wait_us(5);};
    for (int i=0;i<6;i++) regs[i]= spireadReg(0x28 + i );// 14bit signed   1G = 413 9.8m/s**2
//    STSPI.frequency(); //1MHz
    *tx = (short)(regs[0] | (regs[1]<<8)) >> 3;
    *ty = (short)(regs[2] | (regs[3]<<8)) >> 3;
    *tz = (short)(regs[4] | (regs[5]<<8)) >> 3;
    return(0);
}



/*************************************************
  Read a regster from SPI
*************************************************/
static unsigned char spireadReg(unsigned char ad){
    unsigned char r;
#ifdef USESPI    
    spiWriteCS(0);
    wait_us(1);
    spiWrite(ad | 0x80);  
    r = spiWrite(0);
    wait_us(1);
    spiWriteCS(1);
#else
    char Reg=ad;
    char Data[2];

    i2c.write((deviceAddress << 1) & 0xFE, (char *)&Reg, 1);
    i2c.read((deviceAddress << 1) | 0x01, (char *)Data, 2);
    r = Data[1];    
//    pc.printf("read regs %02x %02x\r\n", Data[0],Data[1]);
#endif    
    return(r);
}

/*************************************************
  Read multi regsters from SPI
*************************************************/
static int spireadRegs(unsigned char ad,unsigned char *p,int bytes){
#if 1
   while(bytes--) {
      *p = spireadReg( ad );
      p++;
      ad++;
   }    
#else   
   spiWriteCS(0);
    wait_us(1);
    spiWrite(ad | 0x80 );  
   while(bytes--) {
      *p++ = spiWrite(0);
   }
   wait_us(1);
   spiWriteCS(1);
#endif  
    return(0);
}

/*************************************************
  Write a regster via SPI
*************************************************/
static unsigned char spiwriteReg(unsigned char ad,unsigned char val){
    unsigned char r;
#ifdef USESPI
    spiWriteCS(0);
    wait_us(1);
    spiWrite(ad);  
    r = spiWrite(val);
    wait_us(1);
    spiWriteCS(1);
#else 
//i2c
    uint8_t buf[2];
    
    buf[0] = ad;
    buf[1] = val;
    i2c.write((deviceAddress << 1) & 0xFE, (char *)buf, 2);
#endif    
    return(r);
}


static unsigned char i2cReadReg(unsigned char ad,unsigned char val){
    unsigned char r;
#ifdef USESPI
#else 
//i2c
    uint8_t buf[2];
    
    buf[0] = ad;
    buf[1] = val;
    i2c.write((deviceAddress << 1) & 0xFE, (char *)buf, 2);

#endif    
    return(r);
}


