#include "mbed.h"
#include "string.h"
#include "nRF24L01P.h"
#include "SDFileSystem.h"

//マイコンボードL432KC用のログ読み取り治具の最終プログラムです。

//DigitalOut    nRF_csn(D3 /*PB_6*/ );  //これは、もしかしてこのコードでも定義しとかないとかな？と思って定義した通信モジュのピン定義だけど、
//DigitalOut    nRF_ce(D6);             //ライブラリに定義があり、そことかぶるから不要と言われたので不要！
//DigitalIn     IRQ(D9);
//SPI           nRF_spi(A6, A5, A1);// mosi, miso, sck
RawSerial  pc(PA_2, PA_15);  //432KCはpcとつながってるのはUART2らしい。UART使いたいならUART1。
RawSerial  UDGS01(D1, D0);        // ログ読み取り対象とのシリアル通信用にUARTピンを新たに定義。
Ticker     interrput;

SDFileSystem sd1(PB_5_ALT0, PB_4_ALT0, PB_3_ALT0, A0, "sd1"); // mosi, miso, sclk, cs__このコードの場所はメインの上にしよう_SDFileSystemを新しくしたら、ヘッダ側(SDFileSystem.cppの122行辺り)で周波数を定義してたので,(10MHzぐらいに設定）周波数は削除した書き方に


#define TRANSFER_SIZE   32
int      out_flg = 0;
int      rcv_flg = 0;
int      snd_flg = 0;
char   txData1[TRANSFER_SIZE];
char   txData2[TRANSFER_SIZE];    /*char型で一文字ずつ配列に入れていき、表示する。char型は一つ1バイトなので、32個ずつ溜まったら送るようにする。*/
int      txDataIdx = 0;                 
int      txDataCnt=0;
char   rxData1[TRANSFER_SIZE];
char   rxData2[TRANSFER_SIZE];     /*char型で一文字ずつ配列に入れていき、表示する。char型は一つ1バイトなので、32個ずつ溜まったら送るようにする。*/

int      rxDataIdx = 0;                 
int      rxDataCnt=0;
int      i=0;
int      which=0;
int      bufferidx=0;
FILE     *fp;
int      open_flg = 0;
int      write_flg = 0;
int      w = 0;

nRF24L01P my_nrf24l01p(A6, A5, A4, D3, D6, D9);    // mosi, miso, sck, csn, ce, irq

void timer(){ //1秒ごとにカウントする。
   i++;
}

void recieve(){
    if(UDGS01.readable()){
             
     // ...read the data into the receive buffer
        txData1[txDataIdx] = UDGS01.getc();  //getcharだと、PCからのキーボード入力という標準コンソール？のやつだからだめらしい

        txDataIdx++;
              
        if (txDataIdx == TRANSFER_SIZE) {//最初の32回
           memcpy(txData2, txData1, TRANSFER_SIZE);
               
               txDataIdx=0;
               write_flg = 2;
               snd_flg = 1;
               
        }
               
    }
    
}
      
int main() {
  
    pc.baud(115200);
    UDGS01.baud(115200);
   
   wait(1);
   
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);//2400-2525
    my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_12_DB);//mAX 0  -6 -12 -18
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);//250k,1000,2000K
    // Display the (default) setup of the nRF24L01+ chip
    printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );


    printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );//mAX 32
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
  
    memset(txData1, '\0', sizeof(txData1));
    memset(txData2, '\0', sizeof(txData2));
    memset(rxData1, '\0', sizeof(rxData1));
    memset(rxData2, '\0', sizeof(rxData2));
    
   printf("Hellooooo\r\n");
    wait_ms(10);
   
   if(open_flg == 0){
        wait(1);
        fp = fopen("/sd1/testlog.txt", "a");             
         
         if (fp == NULL)
        {
            printf("open error!!\r\n");

        }     
         else{

         printf("SD opened\r\n");
         fprintf(fp, "opened!!\r\n");
         fclose(fp);
         wait_ms(10);
         open_flg = 1;
            
         }
   }

    interrput.attach(&timer, 1);//1 msec 10Khz
    UDGS01.attach(recieve,Serial::RxIrq);//ログ読み取り対象からのデータ受信したら割り込み発生してrecieveを呼び出す


 
 while(1){
       
       if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {    //受信可能であれば
            
         rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, (char*)(rxData1),TRANSFER_SIZE );           
         
         if(rcv_flg == 0){   
             memcpy(rxData2, rxData1, TRANSFER_SIZE);
             wait_ms(1);
             rcv_flg = 1;
         }
        
         if(rcv_flg == 1){
          for(; rxDataIdx >= TRANSFER_SIZE; rxDataIdx++)
           {
            printf("%c", rxData2[rxDataIdx]);
           }
          rcv_flg = 0;
          write_flg = 1;
          rxDataIdx=0;
         }
                    
         if(open_flg == 1){
             fp = fopen("/sd1/recieve_log.txt", "a");
           if (fp == NULL)
           {
            printf("open error!!\r\n");
           }else{
             open_flg = 2;  //open_flg を1以外の数字にして動かなくしてるだけで、2であることに意味はない
           }
         }
         
         if(write_flg == 1){

            fwrite(rxData2, sizeof(char), TRANSFER_SIZE, fp);
            wait_ms(1);
            w++;
            
            if(w >= 16){ //512バイト書き込むとSDカードを閉じるようにする       
               if(i >= 60)i = 0; //wが増える限りはiが300以上行く前にここで0になる
               w = 0;
               open_flg = 1;
               fclose(fp);
               wait_ms(1);
            
            }
            write_flg = 0;
          }
   
         if(i >= 300){ //ログが出ないことでwが止まってiがリセットされず、300秒経過したらファイル閉じる    
              i = 0;
              w = 0;
              open_flg = 1;
              fclose(fp);
         }
         
      }//my_nrf24l01p.readableの{

       if (snd_flg==1) {//送信用 送信側もログをSDカードに書き込むようにする。
          snd_flg=0;
               
          if(open_flg == 1){
             fp = fopen("/sd1/transfer_log.txt", "a");
             if (fp == NULL)
              {
                printf("open error!!\r\n");
//            while(1);
              }else{
                open_flg = 2;
             }
         }
         
         if(write_flg == 2){
            fwrite(txData2, sizeof(char), TRANSFER_SIZE, fp);
            wait_ms(1);       
            w++;
            
            if(w >= 16){      
              if(i >= 60)i = 0;
              w = 0;
              open_flg = 1;
              fclose(fp);
              wait_ms(1);
          }

            write_flg = 0;
         }

         if(i >= 300){      
            w = 0;
            open_flg = 1;
            fclose(fp);
            wait_ms(1);
          }

         my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char *)txData2 , TRANSFER_SIZE  );             
         printf("1\r\n");
         wait_ms(1);
     }    

         
        
 } //一番最初のwhileの}
}