
//受信用と送信用を一つにする！ボタンで切り替え(元のプログラムは44で、44-2を貼り付ける)

#include "mbed.h"
#include "nRF24L01P.h"
#include "SDFileSystem.h"

RawSerial  pc(PA_2, PA_3);  //ここはpcとケーブルでつないだときにシリアル通信させてたところだから、ここから牛のUARTにつなぐだけで大丈夫なはず。→ここは元々ST基板のPC部分(パキッと折れそうな方)との通信用に使われてるから他のシリアルは無理らしい。
RawSerial  UDGS01(PA_0, PA_1);        // UD-GS01とのシリアル通信用にUARTピンを新たに定義。
Ticker     interrput;

#define TRANSFER_SIZE   32
int      out_flg = 0;
int      rcv_flg = 0;
int      snd_flg = 0;
char   txData1[TRANSFER_SIZE];
char   txData2[TRANSFER_SIZE];    /*char型で一文字ずつ配列に入れていき、表示する。char型は一つ1バイトなので、32個ずつ溜まったら送るようにする。*/
int      txDataIdx = 0;                 
int      txDataCnt=0;
char   rxData1[TRANSFER_SIZE];
char   rxData2[TRANSFER_SIZE];     /*char型で一文字ずつ配列に入れていき、表示する。char型は一つ1バイトなので、32個ずつ溜まったら送るようにする。*/

int      rxDataIdx = 0;                 
int      rxDataCnt=0;
int      i=0;
int      which=0;
int      bufferidx=0;
FILE     *fp;
int      open_flg = 0;
int      write_flg = 0;
int      close_flg = 0;

nRF24L01P my_nrf24l01p(D11, D12, D13, D10, D9,D8);    // mosi, miso, sck, csn, ce, irq
//nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

void timer(){
   uint16_t ain;
   
      
      if(rcv_flg == 1) { 
        
        pc.printf("%c", rxData2[rxDataIdx]);
        rxDataIdx++;
        
        
        if (rxDataIdx >= TRANSFER_SIZE){ 
        write_flg = 1;
        rxDataIdx=0;
        rcv_flg = 0;
        i++;
         }
        
               
      }
      /*
      if(i>5){
          i = 0;
          close_flg = 1;
      }
      */    

}

void recieve(){
    if(UDGS01.readable()){
             
     // ...read the data into the receive buffer
        txData1[txDataIdx] = UDGS01.getc();  //getcharだと、PCからのキーボード入力という標準コンソール？のやつだからだめらしい
//        pc.printf("tx[%d] = %s", txDataIdx, &txData[txDataIdx]);
        txDataIdx++;
              
        if (txDataIdx == TRANSFER_SIZE) {//最初の32回
           memcpy(txData2, txData1, TRANSFER_SIZE);
               
               txDataIdx=0;
               snd_flg = 1;
               
        }
               
    }
    
}
      
int main() {
  
    pc.baud(115200);
    UDGS01.baud(115200);
   
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(NRF24L01P_MIN_RF_FREQUENCY);//2400-2525
    my_nrf24l01p.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_12_DB);//mAX 0  -6 -12 -18
    my_nrf24l01p.setAirDataRate(NRF24L01P_DATARATE_1_MBPS);//250k,1000,2000K
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
//    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );
    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );//mAX 32
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
    
    
    SDFileSystem *sd = new SDFileSystem(PB_15, PB_14, PB_13, PC_4, "sd", NC, SDFileSystem::SWITCH_NONE, 20000000); // mosi, miso, sclk, name, cs, card detect, sw type, freq
    wait_ms(100);
   
   if(open_flg == 0){
        fp = fopen("/sd/testlog.txt", "a");             
         
         if (fp == NULL)
        {
            printf("open error!!\r\n");
//            while(1);
        }     
         else{
//            fwrite(rxData3, sizeof(char), TRANSFER_SIZE, fp);
         fprintf(fp, "opened!!\r\n");
         fclose(fp);
         open_flg = 1;
            wait(0.5);
         }
   }

    interrput.attach(&timer, 0.1);//100 usec 10Khz
    UDGS01.attach(recieve,Serial::RxIrq);//牛からのデータ受信したら割り込み発生してrecieveを呼び出す


 //   my_nrf24l01p.flush_rx_fifo();
 while(1){
       
       if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {    //受信可能であれば
            
         rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, (char*)(rxData1),TRANSFER_SIZE );           
         
         if(rcv_flg == 0){   
             memcpy(rxData2, rxData1, TRANSFER_SIZE);
             wait(0.2);
             }

//             memcpy(rxData3, rxData1, TRANSFER_SIZE);
             
         if(open_flg == 1){
             fp = fopen("/sd/testlog.txt", "a");
           if (fp == NULL)
           {
            printf("open error!!\r\n");
//            while(1);
           }else{
             open_flg = 2;
           }
         }
         
         if(write_flg == 1){
//            fprintf(fp, "check\r\n");
            fwrite(rxData2, sizeof(char), TRANSFER_SIZE, fp);
            wait(1);       
            
            fclose(fp);
            wait(0.2);
//            close_flg = 0;
            write_flg = 0;
            open_flg = 1;
         }
         
       rcv_flg = 1;
//       wait(1);
      }

       if (snd_flg==1) {//最初のバッファ
               snd_flg=0;
               
               my_nrf24l01p.write( NRF24L01P_PIPE_P0, (char *)txData2 , TRANSFER_SIZE  );             
               pc.putc('1');
               wait(2);
         }    

         
         
 } //一番最初のwhileの}
}
