#include "mbed.h"
#include "EEPROM_lib.h"

Serial pc(USBTX, USBRX, 230400);
I2C i2c_bus(p28, p27);
EEPROM_lib EEPROM(i2c_bus, 1);
DigitalOut pinA(p21);
DigitalOut pinB(p22);
DigitalOut pinC(p23);

void setEEPROMGroup(int group_num);

int main() {
    
    pc.printf("Please Input '7' to Start Progeam\r\n");
    
    while(1) {
        if(pc.readable()){
            int c = pc.getc();
            pc.printf("Input: %c\r\n", c);
            if(c == '7'){
                break;
            }
        }
    }
    
    int ptr, n = 0;
    int eeprom_ptr = 0;
    /*
// ***************************************************
**Write:buff_ptrとptrを混同してるからうまくいかないプログラム
// ***************************************************
    for(int ii = 0; ii < 2; ii ++){
        pc.printf("Start to write %d EEPROM\r\n",ii);
        setEEPROMGroup(ii);
        EEPROM.setWriteAddr(1, 0, 0x00, 0x00);
        while(1){
            while(1){
                ptr = EEPROM.chargeBuff((int)n++);
                if(ptr == 128){
                    EEPROM.writeBuff();
                    ptr = EEPROM.setNextPage();
                    break;
                }
            }
            if(ptr == 0x01000000){
                ptr = 0;
                break;
            }
        }
    }
    */
    
// ***************************************************
// Write:buff_ptrとptrの混同問題を解決したあとのプログラム
// ***************************************************
    
    for(int i = 0; i < 4; i++){
        pc.printf("Start to write %d EEPROM\r\n", i);
        setEEPROMGroup(i);
        EEPROM.setWriteAddr(1, 0, 0x00, 0x00);
        
        while(1){
            ptr = EEPROM.chargeBuff((int)n++);
            //ptr = EEPROM.chargeBuff((char)0xff);
            if(ptr == 128){
                EEPROM.writeBuff();
                //ptr = EEPROM.setNextPage();
                eeprom_ptr = EEPROM.setNextPage();
                //pc.printf("eeprom_ptr: %08x\r\n", eeprom_ptr);
            }
            
            if(eeprom_ptr == 0x01000000){
                ptr = 0;
                eeprom_ptr = 0;
                break;
            }
        }
    }
    
// ***************************************************
// Read
// ***************************************************    
    
    char data[128];
    int num, block;
    char ADDR_H, ADDR_L;
    
    num = 1;
    //block = 0;
    //ADDR_H = ADDR_L = 0x00;
    
    //setEEPROMGroup(0);
    for(int j = 0; j < 4; j ++){
        pc.printf("Start to read %d EEPROM\r\n",j);
        
        setEEPROMGroup(j);
        block = 0;
        ADDR_H = ADDR_L = 0x00;
        
        for(int i = 0; i < 1024; i ++){
            switch(i){
                case 512:
                num = 1;
                block = 1;
                break;
                
                case 1024:
                num = 2;
                block = 0;
                break;
            }
            
            EEPROM.readMultiByte(num, block, ADDR_H, ADDR_L, data, 128);
            for(int x = 0; x < 128; x ++){
                pc.printf("%02x ", data[x]);
            }
            pc.printf("\r\n");
            
            if(ADDR_L == 0x00){
                ADDR_L = 0x80;
            }
            else{
                ADDR_L = 0x00;
                ADDR_H ++;
            }
        }
    }
    
// ***************************************************
// 入力した数字の文字列をint型として受け取る
// ***************************************************
    
    /*
    while(1) {
        if(pc.readable()){
            int c = pc.getc();
            pc.printf("Input: %c\r\n", c);
            setEEPROMGroup(c-48);
        }
    }
    */
}

// ***************************************************
// マルチプレクサで使うEEPROMを変更する
// ***************************************************
void setEEPROMGroup(int group_num){
    switch(group_num){
        case 0:
        pinA = 0;
        pinB = 0;
        pinC = 0;
        break;
        
        case 1:
        pinA = 1;
        pinB = 0;
        pinC = 0;
        break;
        
        case 2:
        pinA = 0;
        pinB = 1;
        pinC = 0;
        break;
        
        case 3:
        pinA = 1;
        pinB = 1;
        pinC = 0;
        break;
    }
}
