#include "mbed.h"
#include "EEPROM_lib.h"

// ***************************************************
// コンストラクタ
// ***************************************************
Serial pc(USBTX, USBRX, 230400);
I2C i2c_bus(p28, p27);

EEPROM_lib EEPROM(i2c_bus, 4);

DigitalOut pinA(p21);
DigitalOut pinB(p22);
DigitalOut pinC(p23);

// ***************************************************
// 関数の宣言
// ***************************************************
void setEEPROMGroup(int group_num);

// ***************************************************
// メイン関数
// ***************************************************
int main() {
    pc.printf("Please Input '7' to Start Progeam\r\n");
    
    while(1) {
        if(pc.readable()){
            int c = pc.getc();
            pc.printf("Input: %c\r\n", c);
            if(c == '7'){
                break;
            }
        }
    }
    
    /*
    int ptr;
    float n = 0;
    int eeprom_ptr = 0;
    */
    
    char data[128];
    int num, block;
    char ADDR_H, ADDR_L;
    
    num = 1;
    //block = 0;
    //ADDR_H = ADDR_L = 0x00;
    
    //setEEPROMGroup(0);
    for(int j = 0; j < 4; j ++){
        pc.printf("Start to read %d EEPROM\r\n",j);
        
        setEEPROMGroup(j);
        num = 1;
        block = 0;
        ADDR_H = ADDR_L = 0x00;
        
        for(int i = 0; i < 4096; i ++){
            switch(i){
                case 512:
                num = 1;
                block = 1;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 1024:
                num = 2;
                block = 0;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 1536:
                num = 2;
                block = 1;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 2048:
                num = 3;
                block = 0;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 2560:
                num = 3;
                block = 1;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 3072:
                num = 4;
                block = 0;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
                case 3584:
                num = 4;
                block = 1;
                /*
                pc.printf("********************\r\n");
                pc.printf("num : %d, block %d\r\n",num,block);
                pc.printf("********************\r\n");
                */
                break;
                
            }
            
            EEPROM.readMultiByte(num, block, ADDR_H, ADDR_L, data, 128);
            /*
            for(int x = 0; x < 128; x ++){
                pc.printf("%02x ", data[x]);
            }
            pc.printf("\r\n");
            */
            int eep_buf = 0;
            
            float eep_data_f;
            int eep_data_i;
            char eep_data_c;
            
            eep_data_c = *reinterpret_cast<char*>(&data[eep_buf]);
            eep_buf += 1;
            pc.printf("%d ", eep_data_c);
            
            eep_data_i = *reinterpret_cast<int*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%d ", eep_data_i);
            
            //eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            //eep_buf += 4;
            //pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_c = *reinterpret_cast<char*>(&data[eep_buf]);
            eep_buf += 1;
            pc.printf("%d ", eep_data_c);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_f = *reinterpret_cast<float*>(&data[eep_buf]);
            eep_buf += 4;
            pc.printf("%f ", eep_data_f);
            
            eep_data_c = *reinterpret_cast<char*>(&data[eep_buf]);
            eep_buf += 1;
            pc.printf("%d ", eep_data_c);
            
            eep_data_c = *reinterpret_cast<char*>(&data[eep_buf]);
            eep_buf += 1;
            pc.printf("%d ", eep_data_c);
            
            eep_data_c = *reinterpret_cast<char*>(&data[eep_buf]);
            eep_buf += 1;
            pc.printf("%d ", eep_data_c); 
            
            pc.printf("\r\n"); 
            
            if(ADDR_L == 0x00){
                ADDR_L = 0x80;
            }
            else{
                ADDR_L = 0x00;
                ADDR_H ++;
            }
        }
    }
}

// ***************************************************
// マルチプレクサで使うEEPROMを変更する
// ***************************************************
void setEEPROMGroup(int group_num){
    switch(group_num){
        case 0:
        pinA = 0;
        pinB = 0;
        pinC = 0;
        break;
        
        case 1:
        pinA = 1;
        pinB = 0;
        pinC = 0;
        break;
        
        case 2:
        pinA = 0;
        pinB = 1;
        pinC = 0;
        break;
        
        case 3:
        pinA = 1;
        pinB = 1;
        pinC = 0;
        break;
    }
}

