#include "mbed.h"
#include "mics_vz_89te.h"

//https://github.com/HGrabas/MICS-VZ-89TE/blob/master/MICS-VZ-89TE/MICS-VZ-89TE.cpp
    
extern Serial pc;


MICS_VZ_89TE::MICS_VZ_89TE(PinName sda, PinName scl, uint8_t addr):i2c(sda, scl)
{
    _i2caddr = addr;
    i2c.frequency(100000);
}


char MICS_VZ_89TE::readSensor(int &co2, int &voc) 
{
    static char data[7];
    this->readData(MICS_VZ_89TE_ADDR_CMD_GETSTATUS, data);
    
    co2 = (int)(data[1] - 13) * (1600.0 / 229) + 400; // ppm: 400 .. 2000
    voc = (int)(data[0] - 13) * (1000.0 / 229); // ppb: 0 .. 1000
    
/*
    for (int i=0; i<sizeof(data); i++)
    {
       pc.printf ("[%d]=%02X, ", i, data[i]);
    }
    pc.printf ("\r\n\r\n");
*/    
        
    return data[5]; // status
}

void MICS_VZ_89TE::getVersion(void) 
{
    static char data[7];
    this->readData(MICS_VZ_89TE_DATE_CODE, data);
    pc.printf ("Year=%d Month=%d Day=%d, Rev=%d CRC=%02x\r\n", data[0], data[1], data[2], data[3], data[6]);
}

void MICS_VZ_89TE::readData(unsigned char reg, char data[])
{
    char send_data[6] = { reg, 0, 0, 0, 0, 0 };

    // send instruction to device
    i2c.write(_i2caddr, send_data, sizeof(send_data));
    
    // wait for 100ms as per datasheet
    wait (0.1);
    
    // read data from device    
    i2c.read (_i2caddr, data, sizeof(data));
}


int MICS_VZ_89TE::readVOC(int &VOCvalue){
    
    char send_data[6] = { 0x0c, 0, 0, 0, 0, 0 };
    char recv_data[7] = {0,0,0,0,0,0,0};    
    
    i2c.write(_i2caddr, send_data, 6);
    
    wait(0.1f);
    
    i2c.read(_i2caddr, recv_data, 7);
    for (int i=0; i<sizeof(recv_data); i++)
    {
       pc.printf ("[%d]=%02x,  ", i, recv_data[i]);
    }
    pc.printf ("\r\n");
    
    VOCvalue = (recv_data[0]-13)*(1000/229);
    
    return 0;
}


/*
byte MICS_VZ_89TE::getCRC(byte *buffer, byte size) 
{
    byte crc = 0x00;
    byte i = 0x00;
    word sum = 0x0000;
    
    // Summation with carry
    for(i=0; i < size; i++) 
    {
        sum += buffer[i];
    }
    
    crc = (byte)sum;
    crc += (sum / 0x0100); // Add with carry
    crc = 0xFF-crc; // Complement

    return(crc);
}
*/

