#ifndef MICS_VZ_89TE_h
#define MICS_VZ_89TE_h

#include "mbed.h"

// magic numbers
//#define MICS_VZ_89TE_ADDR               0x70    // 0x70 default I2C address
//#define MICS_VZ_89TE_ADDR_8BIT          (MICS_VZ_89TE_ADDR << 1)            // 0xE0 default I2C address
//#define MICS_VZ_89TE_I2C_READ           (MICS_VZ_89TE_ADDR << 1) | 0x01     // 0xE1    // Used for I2C read
//#define MICS_VZ_89TE_I2C_WRITE          (MICS_VZ_89TE_ADDR << 1) & 0xFE     // 0xE0    // Used for I2C write

// registers
#define MICS_VZ_89TE_SET_PPM_CO2        0x08    // Used to recalibrate sensor
#define MICS_VZ_89TE_ADDR_CMD_GETSTATUS 0x0C    // This command is used to read the VZ89 status coded with 6 bytes:
#define MICS_VZ_89TE_DATE_CODE          0x0D    // Returns the revision code of the sensor
#define MICS_VZ_89TE_GET_R0             0x10    // Calibration resistance



class MICS_VZ_89TE
{
    public:
        MICS_VZ_89TE(PinName sda, PinName scl, uint8_t _i2caddr);
        int readVOC(int &VOCvalue);            
        
        bool begin(void);
        char readSensor(int &co2, int &voc);
        void getVersion(void);
        
    private:    
        uint8_t _i2caddr;
        I2C i2c;
        
        float co2, voc;

        void readData(unsigned char reg, char data[]);
};

#endif