/*Programa com IHM04A1 (L6206) e bluetooth com 2 motores
 Autor: Hugo Campos
 Staus: Funcionando
 Data:04/10/2020
*/

#include "mbed.h"

DigitalOut IN1A     (D5);
DigitalOut IN2A     (D4);
DigitalOut ENB      (A4);
PwmOut     ENA      (D2);
PwmOut     IN1B     (A0);
PwmOut     IN2B     (A1);


Serial bt(PA_11,PA_12); // OU (D10,D2)
Serial pc(USBTX,USBRX);

int main()
{
    float dutyENA =  0.50;
    float dutyIN1B = 0.60;
    float dutyIN2B = 0.60;
    bt.baud(9600);

    //prints data on mobile
    bt.printf("Connection Established");
    while(1) {
        if (bt.readable()) {
            char CONTROL=  bt.putc(bt.getc());

            if(CONTROL == 'R') { // Ré
                ENA.write(dutyENA);
                ENB = 1;
                IN1A = 1;
                IN2A = 0;
                IN1B=0;
                IN2B.write(dutyIN2B);
                bt.printf("Ré");
                wait_ms(500);
            }
            if(CONTROL == 'F') { //Frente
                ENA.write(dutyENA);
                ENB = 1;
                IN1A = 0;
                IN2A = 1;
                IN2B = 0;
                IN1B.write(dutyIN1B);
                bt.printf("Frente");
                wait_ms(500);
            }
            if(CONTROL == 'D') {
                ENA.write(dutyENA);
                ENB = 0;
                IN1A = 0;
                IN2A = 1;
                bt.printf("motor para esquerda");
                wait_ms(500);
            }
            if(CONTROL == 'E') {
                ENA = 0;
                ENB = 1;
                IN2B=0;
                IN1B.write(dutyIN1B);
                bt.printf("motor para Direita");
                wait_ms(500);
            }
            if(CONTROL == 'T') {
                ENA = 0;
                ENB =0;
                IN1A = 0;
                IN2A = 0;
                IN2B = 0;
                IN1B = 0;
                pc.printf("motor parado");
                wait_ms(500);
            }

            ENA = 0;
            ENB = 0;
        }
    }
}